/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.core.impl.bundled;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.api.SlingJakartaHttpServletResponse;
import org.apache.sling.api.scripting.LazyBindings;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.scripting.api.BindingsValuesProvider;
import org.apache.sling.scripting.api.BindingsValuesProvidersByContext;
import org.apache.sling.scripting.api.resource.ScriptingResourceResolverProvider;
import org.apache.sling.scripting.core.ScriptHelper;
import org.apache.sling.scripting.core.impl.InternalScriptHelper;
import org.apache.sling.scripting.core.impl.bundled.BundledScriptContext;
import org.apache.sling.scripting.core.impl.bundled.ExecutableUnit;
import org.apache.sling.scripting.core.impl.bundled.LogWriter;
import org.apache.sling.scripting.core.impl.bundled.SlingScriptAdapter;
import org.apache.sling.scripting.core.impl.helper.ProtectedBindings;
import org.apache.sling.scripting.spi.bundle.BundledRenderUnit;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ScriptContextProvider.class})
public class ScriptContextProvider {
    private static final Logger LOG = LoggerFactory.getLogger(ScriptContextProvider.class);
    private static final long WARN_LIMIT_FOR_BVP_NANOS = 1000000L;
    private static final String BINDINGS_THRESHOLD_MESSAGE = "Adding the bindings of %s took %s microseconds which is above the hardcoded limit of %s microseconds; if this message appears often it indicates that this BindingsValuesProvider has an impact on general page rendering performance.";
    private static final Set<String> PROTECTED_BINDINGS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("request", "response", "jakartaRequest", "jakartaResponse", "reader", "resource", "resolver", "out", "log", "sling", "javax.script.filename", BundledRenderUnit.VARIABLE)));
    @Reference
    private BindingsValuesProvidersByContext bvpTracker;
    @Reference
    private ScriptEngineManager scriptEngineManager;
    @Reference
    private ScriptingResourceResolverProvider scriptingResourceResolverProvider;

    public ExecutableContext prepareScriptContext(SlingJakartaHttpServletRequest request, SlingJakartaHttpServletResponse response, ExecutableUnit executable) throws IOException {
        InternalScriptHelper scriptHelper = new InternalScriptHelper(executable.getBundleContext(), new SlingScriptAdapter(request.getResourceResolver(), executable.getPath(), "sling/bundle/resource"), request, response, executable.getServiceCache());
        ScriptEngine scriptEngine = this.scriptEngineManager.getEngineByName(executable.getScriptEngineName());
        if (scriptEngine == null && (scriptEngine = this.scriptEngineManager.getEngineByExtension(executable.getScriptExtension())) == null) {
            throw new IllegalStateException(String.format("Cannot find a script engine with name %s and extension %s for executable %s.", executable.getScriptEngineName(), executable.getScriptExtension(), executable.getPath()));
        }
        SlingBindings bindings = new SlingBindings();
        bindings.put("properties", () -> scriptHelper.getJakartaRequest().getResource().getValueMap());
        bindings.put("jakartaRequest", (Object)scriptHelper.getJakartaRequest());
        bindings.put("jakartaResponse", (Object)scriptHelper.getJakartaResponse());
        bindings.put("reader", (Object)scriptHelper.getJakartaRequest().getReader());
        bindings.put("out", (Object)scriptHelper.getJakartaResponse().getWriter());
        bindings.put("resource", (Object)scriptHelper.getJakartaRequest().getResource());
        bindings.put("resolver", (Object)scriptHelper.getJakartaRequest().getResource().getResourceResolver());
        Logger scriptLogger = LoggerFactory.getLogger((String)executable.getName());
        bindings.put("log", (Object)scriptLogger);
        bindings.put("sling", (Object)scriptHelper);
        bindings.put(BundledRenderUnit.VARIABLE, (Object)executable);
        bindings.put("javax.script.filename", (Object)executable.getPath());
        bindings.put("javax.script.filename".replace(".", "_"), (Object)executable.getPath());
        ProtectedBindings protectedBindings = new ProtectedBindings((Bindings)bindings, PROTECTED_BINDINGS);
        long inclusionStart = System.nanoTime();
        for (BindingsValuesProvider bindingsValuesProvider : this.bvpTracker.getBindingsValuesProviders(scriptEngine.getFactory(), "request")) {
            long start = System.nanoTime();
            bindingsValuesProvider.addBindings((Bindings)((Object)protectedBindings));
            long stop = System.nanoTime();
            LOG.trace("Invoking addBindings() of {} took {} nanoseconds", (Object)bindingsValuesProvider.getClass().getName(), (Object)(stop - start));
            if (stop - start <= 1000000L) continue;
            if (request.getRequestProgressTracker() != null) {
                request.getRequestProgressTracker().log(String.format(BINDINGS_THRESHOLD_MESSAGE, bindingsValuesProvider.getClass().getName(), (stop - start) / 1000L, 1000L));
                continue;
            }
            if (!LOG.isInfoEnabled()) continue;
            LOG.info(String.format(BINDINGS_THRESHOLD_MESSAGE, bindingsValuesProvider.getClass().getName(), (stop - start) / 1000L, 1000L));
        }
        if (request.getRequestProgressTracker() != null) {
            long duration = (System.nanoTime() - inclusionStart) / 1000L;
            request.getRequestProgressTracker().log("Adding bindings took " + duration + " microseconds");
        }
        BundledScriptContext scriptContext = new BundledScriptContext();
        HashMap<String, LazyBindings.Supplier> slingBindingsSuppliers = new HashMap<String, LazyBindings.Supplier>();
        slingBindingsSuppliers.put("org.apache.sling.api.scripting.ScriptResourceResolver", () -> this.scriptingResourceResolverProvider.getRequestScopedResourceResolver());
        LazyBindings slingScopeBindings = new LazyBindings(slingBindingsSuppliers);
        scriptContext.setBindings((Bindings)slingScopeBindings, -314);
        scriptContext.setBindings((Bindings)bindings, 100);
        scriptContext.setErrorWriter(new LogWriter(scriptLogger));
        scriptContext.setWriter(scriptHelper.getResponse().getWriter());
        scriptContext.setReader(scriptHelper.getRequest().getReader());
        return new ExecutableContext(scriptContext, executable, scriptEngine);
    }

    static class ExecutableContext {
        private final ScriptContext scriptContext;
        private final ExecutableUnit executable;
        private final ScriptEngine scriptEngine;

        private ExecutableContext(ScriptContext scriptContext, ExecutableUnit executable, ScriptEngine scriptEngine) {
            this.scriptContext = scriptContext;
            this.executable = executable;
            this.scriptEngine = scriptEngine;
        }

        void eval() throws ScriptException {
            this.executable.eval(this.scriptEngine, this.scriptContext);
        }

        void clean() {
            Object scriptHelper;
            Bindings engineBindings = this.scriptContext.getBindings(100);
            if (engineBindings != null && engineBindings.containsKey("sling") && (scriptHelper = engineBindings.get("sling")) instanceof ScriptHelper) {
                ((ScriptHelper)scriptHelper).cleanup();
            }
        }
    }
}

