/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.core.impl;

import jakarta.servlet.Servlet;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.apache.sling.api.SlingException;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.api.SlingJakartaHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceWrapper;
import org.apache.sling.api.resource.SyntheticResource;
import org.apache.sling.api.scripting.LazyBindings;
import org.apache.sling.api.scripting.ScriptEvaluationException;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.api.scripting.SlingScript;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.scripting.api.BindingsValuesProvider;
import org.apache.sling.scripting.api.CachedScript;
import org.apache.sling.scripting.api.ScriptCache;
import org.apache.sling.scripting.core.ScriptNameAwareReader;
import org.apache.sling.scripting.core.impl.InternalScriptHelper;
import org.apache.sling.scripting.core.impl.LogWriter;
import org.apache.sling.scripting.core.impl.ServiceCache;
import org.apache.sling.scripting.core.impl.helper.CachedScriptImpl;
import org.apache.sling.scripting.core.impl.helper.ProtectedBindings;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultSlingScript
implements SlingScript,
Servlet,
ServletConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSlingScript.class);
    private static final long WARN_LIMIT_FOR_BVP_NANOS = 1000000L;
    private static final String BINDINGS_THRESHOLD_MESSAGE = "Adding the bindings of %s took %s microseconds which is above the hardcoded limit of %s microseconds; if this message appears often it indicates that this BindingsValuesProvider has an impact on general page rendering performance.";
    private static ThreadLocal<ResourceResolver> requestResourceResolver = new ThreadLocal();
    private static final Set<String> PROTECTED_KEYS = new HashSet<String>(Arrays.asList("request", "response", "jakartaRequest", "jakartaResponse", "reader", "sling", "resource", "resolver", "out", "log"));
    private static final Integer[] SCOPES = new Integer[]{-314, 100, 200};
    private final Resource scriptResource;
    private final String scriptName;
    private final String scriptEncoding;
    private final ScriptEngine scriptEngine;
    private ServletContext servletContext;
    private Dictionary<String, String> initParameters;
    private final BundleContext bundleContext;
    private final Collection<BindingsValuesProvider> bindingsValuesProviders;
    private final ServiceCache cache;
    private final ScriptCache scriptCache;

    DefaultSlingScript(BundleContext bundleContext, Resource scriptResource, ScriptEngine scriptEngine, Collection<BindingsValuesProvider> bindingsValuesProviders, ServiceCache cache, ScriptCache scriptCache) {
        this.scriptResource = scriptResource;
        this.scriptEngine = scriptEngine;
        this.bundleContext = bundleContext;
        this.bindingsValuesProviders = bindingsValuesProviders;
        this.cache = cache;
        this.scriptCache = scriptCache;
        this.scriptName = this.scriptResource.getPath();
        ResourceMetadata meta = this.scriptResource.getResourceMetadata();
        String encoding = meta.getCharacterEncoding();
        if (encoding == null) {
            encoding = "UTF-8";
        }
        this.scriptEncoding = encoding;
    }

    public Resource getScriptResource() {
        ResourceResolver resolver = requestResourceResolver.get();
        if (resolver == null) {
            return this.scriptResource;
        }
        return new LazyScriptResource(this.scriptName, this.scriptResource.getResourceType(), resolver);
    }

    public Object eval(SlingBindings props) {
        return this.call(props, null, new Object[0]);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object call(SlingBindings props, String method, Object ... args) {
        InternalScriptHelper helper;
        Object object;
        Bindings bindings = null;
        Reader reader = null;
        boolean disposeScriptHelper = !props.containsKey((Object)"sling");
        ResourceResolver oldResolver = null;
        try {
            Object flushObject;
            Object result;
            final Bindings b = bindings = this.verifySlingBindings(props);
            ScriptContext ctx = new ScriptContext(){
                private Bindings globalScope;
                private Bindings engineScope;
                private Writer writer;
                private Writer errorWriter;
                private Reader reader;
                private Bindings slingScope;
                {
                    this.engineScope = b;
                    this.writer = (Writer)b.get("out");
                    this.errorWriter = new LogWriter((Logger)b.get("log"));
                    this.reader = (Reader)b.get("reader");
                    this.slingScope = new LazyBindings();
                }

                @Override
                public void setBindings(Bindings bindings, int scope) {
                    switch (scope) {
                        case -314: {
                            this.slingScope = bindings;
                            break;
                        }
                        case 100: {
                            if (bindings == null) {
                                throw new NullPointerException("Bindings for ENGINE scope is null");
                            }
                            this.engineScope = bindings;
                            break;
                        }
                        case 200: {
                            this.globalScope = bindings;
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Invalid scope");
                        }
                    }
                }

                @Override
                public Bindings getBindings(int scope) {
                    switch (scope) {
                        case -314: {
                            return this.slingScope;
                        }
                        case 100: {
                            return this.engineScope;
                        }
                        case 200: {
                            return this.globalScope;
                        }
                    }
                    throw new IllegalArgumentException("Invalid scope");
                }

                @Override
                public void setAttribute(String name, Object value, int scope) {
                    if (name == null) {
                        throw new IllegalArgumentException("Name is null");
                    }
                    Bindings bindings = this.getBindings(scope);
                    if (bindings != null) {
                        bindings.put(name, value);
                    }
                }

                @Override
                public Object getAttribute(String name, int scope) {
                    if (name == null) {
                        throw new IllegalArgumentException("Name is null");
                    }
                    Bindings bindings = this.getBindings(scope);
                    if (bindings != null) {
                        return bindings.get(name);
                    }
                    return null;
                }

                @Override
                public Object removeAttribute(String name, int scope) {
                    if (name == null) {
                        throw new IllegalArgumentException("Name is null");
                    }
                    Bindings bindings = this.getBindings(scope);
                    if (bindings != null) {
                        return bindings.remove(name);
                    }
                    return null;
                }

                @Override
                public Object getAttribute(String name) {
                    if (name == null) {
                        throw new IllegalArgumentException("Name is null");
                    }
                    Integer[] integerArray = SCOPES;
                    int n = integerArray.length;
                    for (int i = 0; i < n; ++i) {
                        Object o;
                        int scope = integerArray[i];
                        Bindings bindings = this.getBindings(scope);
                        if (bindings == null || (o = bindings.get(name)) == null) continue;
                        return o;
                    }
                    return null;
                }

                @Override
                public int getAttributesScope(String name) {
                    if (name == null) {
                        throw new IllegalArgumentException("Name is null");
                    }
                    Integer[] integerArray = SCOPES;
                    int n = integerArray.length;
                    for (int i = 0; i < n; ++i) {
                        int scope = integerArray[i];
                        if (this.getBindings(scope) == null || !this.getBindings(scope).containsKey(name)) continue;
                        return scope;
                    }
                    return -1;
                }

                @Override
                public List<Integer> getScopes() {
                    return Arrays.asList(SCOPES);
                }

                @Override
                public Writer getWriter() {
                    return this.writer;
                }

                @Override
                public Writer getErrorWriter() {
                    return this.errorWriter;
                }

                @Override
                public void setWriter(Writer writer) {
                    this.writer = writer;
                }

                @Override
                public void setErrorWriter(Writer writer) {
                    this.errorWriter = writer;
                }

                @Override
                public Reader getReader() {
                    return this.reader;
                }

                @Override
                public void setReader(Reader reader) {
                    this.reader = reader;
                }
            };
            if (props.getJakartaRequest() != null) {
                oldResolver = requestResourceResolver.get();
                requestResourceResolver.set(props.getJakartaRequest().getResourceResolver());
            }
            ctx.setAttribute("org.apache.sling.api.scripting.ScriptResourceResolver", this.scriptResource.getResourceResolver(), -314);
            reader = this.getScriptReader();
            if (method != null && !(this.scriptEngine instanceof Invocable)) {
                reader = this.getWrapperReader(reader, method, args);
            }
            if (method == null && this.scriptEngine instanceof Compilable) {
                CachedScript cachedScript = this.scriptCache.getScript(this.scriptName);
                if (cachedScript == null) {
                    ScriptNameAwareReader snReader = new ScriptNameAwareReader(reader, this.scriptName);
                    CompiledScript compiledScript = ((Compilable)((Object)this.scriptEngine)).compile(snReader);
                    cachedScript = new CachedScriptImpl(this.scriptName, compiledScript);
                    this.scriptCache.putScript(cachedScript);
                    LOGGER.debug("Adding {} to the script cache.", (Object)this.scriptName);
                } else {
                    LOGGER.debug("Script {} was already cached.", (Object)this.scriptName);
                }
                result = cachedScript.getCompiledScript().eval(ctx);
            } else {
                result = this.scriptEngine.eval(reader, ctx);
            }
            if (method != null && this.scriptEngine instanceof Invocable) {
                try {
                    ((Invocable)((Object)this.scriptEngine)).invokeFunction(method, Arrays.asList(args).toArray());
                }
                catch (NoSuchMethodException e) {
                    throw new ScriptEvaluationException(this.scriptName, "Method " + method + " not found in script.", (Throwable)e);
                }
            }
            if (Boolean.TRUE.equals(flushObject = bindings.get("flush"))) {
                ctx.getWriter().flush();
            }
            ctx.getErrorWriter().flush();
            object = result;
        }
        catch (IOException ioe) {
            try {
                throw new ScriptEvaluationException(this.scriptName, ioe.getMessage(), (Throwable)ioe);
                catch (ScriptEvaluationException see) {
                    throw see;
                }
                catch (ScriptException se) {
                    Throwable cause = se.getCause() == null ? se : se.getCause();
                    throw new ScriptEvaluationException(this.scriptName, se.getMessage(), cause);
                }
            }
            catch (Throwable throwable) {
                InternalScriptHelper helper2;
                if (props.getJakartaRequest() != null) {
                    requestResourceResolver.set(oldResolver);
                }
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (bindings != null && disposeScriptHelper && (helper2 = (InternalScriptHelper)bindings.get("sling")) != null) {
                    helper2.cleanup();
                }
                throw throwable;
            }
        }
        if (props.getJakartaRequest() != null) {
            requestResourceResolver.set(oldResolver);
        }
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException compiledScript) {
                // empty catch block
            }
        }
        if (bindings != null && disposeScriptHelper && (helper = (InternalScriptHelper)bindings.get("sling")) != null) {
            helper.cleanup();
        }
        return object;
    }

    public void init(ServletConfig servletConfig) {
        if (servletConfig != null) {
            Hashtable<String, String> params = new Hashtable<String, String>();
            Enumeration ne = servletConfig.getInitParameterNames();
            while (ne.hasMoreElements()) {
                String name = String.valueOf(ne.nextElement());
                String value = servletConfig.getInitParameter(name);
                ((Dictionary)params).put(name, value);
            }
            this.initParameters = params;
            this.servletContext = servletConfig.getServletContext();
        }
    }

    public void service(ServletRequest req, ServletResponse res) {
        SlingJakartaHttpServletRequest request = (SlingJakartaHttpServletRequest)req;
        try {
            SlingBindings props = new SlingBindings();
            props.setJakartaRequest(request);
            props.setJakartaResponse((SlingJakartaHttpServletResponse)res);
            if (request.getAttribute("jakarta.servlet.include.servlet_path") == null) {
                String contentType = request.getResponseContentType();
                if (contentType != null) {
                    res.setContentType(contentType);
                    if (contentType.startsWith("text/")) {
                        res.setCharacterEncoding("UTF-8");
                    }
                } else {
                    LOGGER.debug("service: No response content type defined for request {}.", (Object)request.getRequestURI());
                }
            } else {
                LOGGER.debug("service: Included request, not setting content type and encoding");
            }
            this.eval(props);
        }
        catch (RuntimeException see) {
            this.logScriptError(request, see);
            throw see;
        }
        catch (Exception e) {
            this.logScriptError(request, e);
            throw new SlingException("Cannot get DefaultSlingScript: " + e.getMessage(), (Throwable)e);
        }
    }

    public ServletConfig getServletConfig() {
        return this;
    }

    public String getServletInfo() {
        return "Script " + this.scriptName;
    }

    public void destroy() {
        this.initParameters = null;
        this.servletContext = null;
    }

    public String getInitParameter(String name) {
        Dictionary<String, String> params = this.initParameters;
        return params != null ? params.get(name) : null;
    }

    public Enumeration<String> getInitParameterNames() {
        Dictionary<String, String> params = this.initParameters;
        return params != null ? params.keys() : null;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public String getServletName() {
        return this.scriptName;
    }

    private Reader getScriptReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)new LazyInputStream(this.scriptResource), this.scriptEncoding));
    }

    private Reader getWrapperReader(final Reader scriptReader, String method, Object ... args) {
        StringBuilder buffer = new StringBuilder(method);
        buffer.append('(');
        for (Object o : args) {
            buffer.append('\"');
            buffer.append(o);
            buffer.append('\"');
        }
        buffer.append(')');
        final String msg = buffer.toString();
        return new Reader(){
            protected boolean doAppend = false;
            protected StringReader methodReader = new StringReader(msg);

            @Override
            public void close() throws IOException {
                scriptReader.close();
            }

            @Override
            public int read(char[] cbuf, int start, int len) throws IOException {
                if (this.doAppend) {
                    return this.methodReader.read(cbuf, start, len);
                }
                int readLen = scriptReader.read(cbuf, start, len);
                if (readLen == -1) {
                    this.doAppend = true;
                    return this.read(cbuf, start, len);
                }
                return readLen;
            }

            @Override
            public int read() throws IOException {
                if (this.doAppend) {
                    return this.methodReader.read();
                }
                int value = scriptReader.read();
                if (value == -1) {
                    this.doAppend = true;
                    return this.methodReader.read();
                }
                return value;
            }

            @Override
            public int read(char[] cbuf) throws IOException {
                return this.read(cbuf, 0, cbuf.length);
            }

            @Override
            public boolean ready() throws IOException {
                return scriptReader.ready();
            }
        };
    }

    Bindings verifySlingBindings(SlingBindings slingBindings) throws IOException {
        Object logObject;
        LazyBindings bindings = new LazyBindings();
        SlingJakartaHttpServletRequest request = slingBindings.getJakartaRequest();
        Object slingObject = slingBindings.get((Object)"sling");
        if (slingObject == null) {
            slingObject = request != null ? new InternalScriptHelper(this.bundleContext, this, request, slingBindings.getJakartaResponse(), this.cache) : new InternalScriptHelper(this.bundleContext, this, this.cache);
        } else if (!(slingObject instanceof SlingScriptHelper)) {
            throw this.fail("sling", "Wrong type");
        }
        SlingScriptHelper sling = (SlingScriptHelper)slingObject;
        bindings.put("sling", (Object)sling);
        if (request != null) {
            SlingJakartaHttpServletResponse response = slingBindings.getJakartaResponse();
            if (response == null) {
                throw this.fail("jakartaResponse", "Missing or wrong type");
            }
            Iterator resourceObject = slingBindings.get((Object)"resource");
            if (resourceObject != null && !(resourceObject instanceof Resource)) {
                throw this.fail("resource", "Wrong type");
            }
            Object resolverObject = slingBindings.get((Object)"resolver");
            if (resolverObject != null && !(resolverObject instanceof ResourceResolver)) {
                throw this.fail("resolver", "Wrong type");
            }
            Object writerObject = slingBindings.get((Object)"out");
            if (writerObject != null && !(writerObject instanceof PrintWriter)) {
                throw this.fail("out", "Wrong type");
            }
            if (slingBindings.get((Object)"sling") != null) {
                if (sling.getJakartaRequest() != request) {
                    throw this.fail("jakartaRequest", "Not the same as request field of SlingScriptHelper");
                }
                if (sling.getJakartaResponse() != response) {
                    throw this.fail("jakartaResponse", "Not the same as response field of SlingScriptHelper");
                }
                if (resourceObject != null && sling.getJakartaRequest().getResource() != resourceObject) {
                    throw this.fail("resource", "Not the same as resource of the SlingScriptHelper request");
                }
                if (resolverObject != null && sling.getJakartaRequest().getResource().getResourceResolver() != resolverObject) {
                    throw this.fail("resolver", "Not the same as the resource resolver of the SlingScriptHelper request's resource");
                }
                if (writerObject != null && sling.getJakartaResponse().getWriter() != writerObject) {
                    throw this.fail("out", "Not the same as writer of the SlingScriptHelper response");
                }
            }
            bindings.put("jakartaRequest", (Object)sling.getJakartaRequest());
            bindings.put("jakartaResponse", (Object)sling.getJakartaResponse());
            bindings.put("request", (Object)sling.getRequest());
            bindings.put("response", (Object)sling.getResponse());
            bindings.put("reader", (Object)sling.getJakartaRequest().getReader());
            bindings.put("resource", (Object)sling.getJakartaRequest().getResource());
            bindings.put("resolver", (Object)sling.getJakartaRequest().getResource().getResourceResolver());
            bindings.put("out", (Object)sling.getJakartaResponse().getWriter());
        }
        if ((logObject = slingBindings.get((Object)"log")) == null) {
            logObject = LoggerFactory.getLogger((String)this.getLoggerName());
        } else if (!(logObject instanceof Logger)) {
            throw this.fail("log", "Wrong type");
        }
        bindings.put("log", logObject);
        for (Map.Entry entry : slingBindings.entrySet()) {
            if (bindings.containsKey(entry.getKey())) continue;
            bindings.put((String)entry.getKey(), entry.getValue());
        }
        if (!this.bindingsValuesProviders.isEmpty()) {
            HashSet<String> protectedKeys = new HashSet<String>();
            protectedKeys.addAll(PROTECTED_KEYS);
            ProtectedBindings protectedBindings = new ProtectedBindings((Bindings)bindings, protectedKeys);
            long inclusionStart = System.nanoTime();
            for (BindingsValuesProvider provider : this.bindingsValuesProviders) {
                long start = System.nanoTime();
                provider.addBindings((Bindings)((Object)protectedBindings));
                long stop = System.nanoTime();
                LOGGER.trace("Invoking addBindings() of {} took {} nanoseconds", (Object)provider.getClass().getName(), (Object)(stop - start));
                if (stop - start <= 1000000L) continue;
                if (request != null && request.getRequestProgressTracker() != null) {
                    request.getRequestProgressTracker().log(String.format(BINDINGS_THRESHOLD_MESSAGE, provider.getClass().getName(), (stop - start) / 1000L, 1000L));
                    continue;
                }
                if (!LOGGER.isInfoEnabled()) continue;
                LOGGER.info(String.format(BINDINGS_THRESHOLD_MESSAGE, provider.getClass().getName(), (stop - start) / 1000L, 1000L));
            }
            if (request != null && request.getRequestProgressTracker() != null) {
                long duration = (System.nanoTime() - inclusionStart) / 1000L;
                request.getRequestProgressTracker().log("Adding bindings took " + duration + " microseconds");
            }
        }
        return bindings;
    }

    private ScriptEvaluationException fail(String variableName, String message) {
        return new ScriptEvaluationException(this.scriptName, variableName + ": " + message);
    }

    private String getLoggerName() {
        String name = this.scriptName;
        name = name.substring(1);
        name = name.replace('.', '$');
        name = name.replace('/', '.');
        return name;
    }

    private void logScriptError(SlingJakartaHttpServletRequest request, Throwable throwable) {
        String message = throwable.getMessage();
        message = message != null ? throwable.getMessage().replace('\n', '/') : throwable.toString();
        request.getRequestProgressTracker().log("SCRIPT ERROR: {0}", new Object[]{message});
    }

    private static final class LazyScriptResource
    extends ResourceWrapper {
        private final String path;
        private final String resourceType;
        private final ResourceResolver resolver;
        private Resource delegatee;

        public LazyScriptResource(String path, String resourceType, ResourceResolver resolver) {
            super(null);
            this.path = path;
            this.resourceType = resourceType;
            this.resolver = resolver;
        }

        public Resource getResource() {
            if (this.delegatee == null) {
                this.delegatee = this.resolver.getResource(this.path);
                if (this.delegatee == null) {
                    this.delegatee = new SyntheticResource(this.resolver, this.path, this.resourceType);
                }
            }
            return this.delegatee;
        }

        public String getPath() {
            return this.path;
        }

        public String getResourceType() {
            return this.resourceType;
        }

        public ResourceResolver getResourceResolver() {
            return this.resolver;
        }
    }

    public static final class LazyInputStream
    extends InputStream {
        private final Resource resource;
        private InputStream delegatee;

        public LazyInputStream(Resource resource) {
            this.resource = resource;
        }

        @Override
        public void close() throws IOException {
            if (this.delegatee != null) {
                this.delegatee.close();
            }
        }

        @Override
        public int available() throws IOException {
            return this.getStream().available();
        }

        @Override
        public int read() throws IOException {
            return this.getStream().read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.getStream().read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.getStream().read(b, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            return this.getStream().skip(n);
        }

        @Override
        public boolean markSupported() {
            try {
                return this.getStream().markSupported();
            }
            catch (IOException iOException) {
                return false;
            }
        }

        @Override
        public synchronized void mark(int readlimit) {
            try {
                this.getStream().mark(readlimit);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public synchronized void reset() throws IOException {
            this.getStream().reset();
        }

        private InputStream getStream() throws IOException {
            if (this.delegatee == null) {
                this.delegatee = (InputStream)this.resource.adaptTo(InputStream.class);
                if (this.delegatee == null) {
                    throw new IOException("Cannot get a stream to the script resource " + this.resource.getPath());
                }
            }
            return this.delegatee;
        }
    }
}

