/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.core;

import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.SlingIOException;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.api.SlingJakartaHttpServletResponse;
import org.apache.sling.api.SlingServletException;
import org.apache.sling.api.request.RequestDispatcherOptions;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.scripting.InvalidServiceFilterSyntaxException;
import org.apache.sling.api.scripting.SlingScript;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.api.wrappers.JakartaToJavaxRequestWrapper;
import org.apache.sling.api.wrappers.JakartaToJavaxResponseWrapper;
import org.apache.sling.api.wrappers.JavaxToJakartaRequestWrapper;
import org.apache.sling.api.wrappers.JavaxToJakartaResponseWrapper;
import org.apache.sling.api.wrappers.SlingHttpServletRequestWrapper;
import org.apache.sling.api.wrappers.SlingHttpServletResponseWrapper;
import org.apache.sling.api.wrappers.SlingJakartaHttpServletRequestWrapper;
import org.apache.sling.api.wrappers.SlingJakartaHttpServletResponseWrapper;
import org.apache.sling.scripting.core.impl.helper.OnDemandReaderJakartaRequest;
import org.apache.sling.scripting.core.impl.helper.OnDemandReaderRequest;
import org.apache.sling.scripting.core.impl.helper.OnDemandWriterJakartaResponse;
import org.apache.sling.scripting.core.impl.helper.OnDemandWriterResponse;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.LoggerFactory;

public class ScriptHelper
implements SlingScriptHelper {
    private final SlingScript script;
    private SlingHttpServletRequest request;
    private SlingHttpServletResponse response;
    private final SlingJakartaHttpServletRequest jakartaRequest;
    private final SlingJakartaHttpServletResponse jakartaResponse;
    protected final BundleContext bundleContext;
    protected List<ServiceReference<?>> references;
    protected Map<String, Object> services;

    public ScriptHelper(BundleContext ctx, SlingScript script) {
        if (ctx == null) {
            throw new IllegalArgumentException("Bundle context must not be null.");
        }
        this.jakartaRequest = null;
        this.jakartaResponse = null;
        this.script = script;
        this.bundleContext = ctx;
    }

    public ScriptHelper(BundleContext ctx, SlingScript script, SlingJakartaHttpServletRequest request, SlingJakartaHttpServletResponse response) {
        if (ctx == null) {
            throw new IllegalArgumentException("Bundle context must not be null.");
        }
        this.script = script;
        this.jakartaRequest = this.wrapIfNeeded(request);
        this.jakartaResponse = this.wrapIfNeeded(response);
        this.bundleContext = ctx;
    }

    @Deprecated
    public ScriptHelper(BundleContext ctx, SlingScript script, SlingHttpServletRequest request, SlingHttpServletResponse response) {
        if (ctx == null) {
            throw new IllegalArgumentException("Bundle context must not be null.");
        }
        this.script = script;
        this.request = this.wrapIfNeeded(request);
        this.response = this.wrapIfNeeded(response);
        this.jakartaRequest = JavaxToJakartaRequestWrapper.toJakartaRequest((SlingHttpServletRequest)this.request);
        this.jakartaResponse = JavaxToJakartaResponseWrapper.toJakartaResponse((SlingHttpServletResponse)this.response);
        this.bundleContext = ctx;
    }

    public SlingScript getScript() {
        return this.script;
    }

    public SlingJakartaHttpServletRequest getJakartaRequest() {
        return this.jakartaRequest;
    }

    public SlingJakartaHttpServletResponse getJakartaResponse() {
        return this.jakartaResponse;
    }

    public SlingHttpServletRequest getRequest() {
        if (this.request == null && this.jakartaRequest != null) {
            SlingHttpServletRequest javaxRequest = JakartaToJavaxRequestWrapper.toJavaxRequest((SlingJakartaHttpServletRequest)this.jakartaRequest);
            this.request = new SlingHttpServletRequestWrapper(javaxRequest){

                public ResourceResolver getResourceResolver() {
                    Resource resource = this.getResource();
                    if (resource != null) {
                        return resource.getResourceResolver();
                    }
                    return super.getResourceResolver();
                }
            };
        }
        return this.request;
    }

    public SlingHttpServletResponse getResponse() {
        if (this.response == null && this.jakartaResponse != null) {
            this.response = JakartaToJavaxResponseWrapper.toJavaxResponse((SlingJakartaHttpServletResponse)this.jakartaResponse);
        }
        return this.response;
    }

    public void include(String path) {
        this.include(path, (RequestDispatcherOptions)null);
    }

    public void include(String path, String options) {
        this.include(path, new RequestDispatcherOptions(options));
    }

    public void include(String path, RequestDispatcherOptions options) {
        RequestDispatcher dispatcher = this.getJakartaRequest().getRequestDispatcher(path, options);
        if (dispatcher != null) {
            try {
                dispatcher.include((ServletRequest)this.getJakartaRequest(), (ServletResponse)this.getJakartaResponse());
            }
            catch (IOException ioe) {
                throw new SlingIOException(ioe);
            }
            catch (ServletException se) {
                throw new SlingServletException(se);
            }
        }
    }

    public void forward(String path) {
        this.forward(path, (RequestDispatcherOptions)null);
    }

    public void forward(String path, String options) {
        this.forward(path, new RequestDispatcherOptions(options));
    }

    public void forward(String path, RequestDispatcherOptions options) {
        RequestDispatcher dispatcher = this.getJakartaRequest().getRequestDispatcher(path, options);
        if (dispatcher != null) {
            try {
                dispatcher.forward((ServletRequest)this.getJakartaRequest(), (ServletResponse)this.getJakartaResponse());
            }
            catch (IOException ioe) {
                throw new SlingIOException(ioe);
            }
            catch (ServletException se) {
                throw new SlingServletException(se);
            }
        }
    }

    @Deprecated
    public void dispose() {
        LoggerFactory.getLogger(this.getClass()).error("ScriptHelper#dispose has been called. This method is deprecated and should never be called by clients!");
    }

    public <T> T getService(Class<T> type) {
        ServiceReference ref;
        Object service;
        Object object = service = this.services == null ? null : this.services.get(type.getName());
        if (service == null && (ref = this.bundleContext.getServiceReference(type)) != null && (service = this.bundleContext.getService(ref)) != null) {
            if (this.services == null) {
                this.services = new HashMap<String, Object>();
            }
            if (this.references == null) {
                this.references = new ArrayList();
            }
            this.references.add(ref);
            this.services.put(type.getName(), service);
        }
        return (T)service;
    }

    public <T> T[] getServices(Class<T> serviceType, String filter) throws InvalidServiceFilterSyntaxException {
        try {
            Collection refsCollection = this.bundleContext.getServiceReferences(serviceType, filter);
            Object[] result = null;
            if (refsCollection != null) {
                ArrayList refsList = new ArrayList(refsCollection);
                Collections.sort(refsList);
                Collections.reverse(refsList);
                ArrayList<Object> objects = new ArrayList<Object>();
                for (ServiceReference reference : refsList) {
                    Object service = this.bundleContext.getService(reference);
                    if (service == null) continue;
                    if (this.references == null) {
                        this.references = new ArrayList();
                    }
                    this.references.add(reference);
                    objects.add(service);
                }
                if (!objects.isEmpty()) {
                    Object[] srv = (Object[])Array.newInstance(serviceType, objects.size());
                    result = objects.toArray(srv);
                }
            }
            return result;
        }
        catch (InvalidSyntaxException ise) {
            throw new InvalidServiceFilterSyntaxException(filter, "Invalid filter syntax", (Throwable)ise);
        }
    }

    public void cleanup() {
        if (this.references != null) {
            for (ServiceReference<?> ref : this.references) {
                this.bundleContext.ungetService(ref);
            }
            this.references.clear();
        }
        if (this.services != null) {
            this.services.clear();
        }
    }

    public void forward(Resource resource) {
        this.forward(resource, (RequestDispatcherOptions)null);
    }

    public void forward(Resource resource, String options) {
        this.forward(resource, new RequestDispatcherOptions(options));
    }

    public void forward(Resource resource, RequestDispatcherOptions options) {
        RequestDispatcher dispatcher = this.getJakartaRequest().getRequestDispatcher(resource, options);
        if (dispatcher != null) {
            try {
                dispatcher.forward((ServletRequest)this.getJakartaRequest(), (ServletResponse)this.getJakartaResponse());
            }
            catch (IOException ioe) {
                throw new SlingIOException(ioe);
            }
            catch (ServletException se) {
                throw new SlingServletException(se);
            }
        }
    }

    public void include(Resource resource) {
        this.include(resource, (RequestDispatcherOptions)null);
    }

    public void include(Resource resource, String options) {
        this.include(resource, new RequestDispatcherOptions(options));
    }

    public void include(Resource resource, RequestDispatcherOptions options) {
        RequestDispatcher dispatcher = this.getJakartaRequest().getRequestDispatcher(resource, options);
        if (dispatcher != null) {
            try {
                dispatcher.include((ServletRequest)this.getJakartaRequest(), (ServletResponse)this.getJakartaResponse());
            }
            catch (IOException ioe) {
                throw new SlingIOException(ioe);
            }
            catch (ServletException se) {
                throw new SlingServletException(se);
            }
        }
    }

    private SlingHttpServletRequest findOnDemandReader(@NotNull SlingHttpServletRequest initialRequest) {
        SlingHttpServletRequest request = initialRequest;
        while (request instanceof SlingHttpServletRequestWrapper) {
            if (request instanceof OnDemandReaderRequest) {
                return null;
            }
            request = ((SlingHttpServletRequestWrapper)request).getSlingRequest();
        }
        if (request instanceof JakartaToJavaxRequestWrapper) {
            SlingJakartaHttpServletRequest initialJakartaRequest = (SlingJakartaHttpServletRequest)((JakartaToJavaxRequestWrapper)request).getRequest();
            SlingJakartaHttpServletRequest entry = this.findOnDemandReader(initialJakartaRequest);
            if (entry == null) {
                return null;
            }
            if (entry instanceof JavaxToJakartaRequestWrapper) {
                request = (SlingHttpServletRequest)((JavaxToJakartaRequestWrapper)entry).getRequest();
                return this.findOnDemandReader(request);
            }
        }
        return request;
    }

    private SlingJakartaHttpServletRequest findOnDemandReader(@NotNull SlingJakartaHttpServletRequest initialRequest) {
        SlingJakartaHttpServletRequest request = initialRequest;
        while (request instanceof SlingJakartaHttpServletRequestWrapper) {
            if (request instanceof OnDemandReaderJakartaRequest) {
                return null;
            }
            request = ((SlingJakartaHttpServletRequestWrapper)request).getSlingRequest();
        }
        if (request instanceof JavaxToJakartaRequestWrapper) {
            SlingHttpServletRequest initialJavaxRequest = (SlingHttpServletRequest)((JavaxToJakartaRequestWrapper)request).getRequest();
            SlingHttpServletRequest entry = this.findOnDemandReader(initialJavaxRequest);
            if (entry == null) {
                return null;
            }
            if (entry instanceof JakartaToJavaxRequestWrapper) {
                request = (SlingJakartaHttpServletRequest)((JakartaToJavaxRequestWrapper)entry).getRequest();
                return this.findOnDemandReader(request);
            }
        }
        return request;
    }

    private SlingHttpServletResponse findOnDemandWriter(@NotNull SlingHttpServletResponse initialResponse) {
        SlingHttpServletResponse response = initialResponse;
        while (response instanceof SlingHttpServletResponseWrapper) {
            if (response instanceof OnDemandWriterResponse) {
                return null;
            }
            response = ((SlingHttpServletResponseWrapper)response).getSlingResponse();
        }
        if (response instanceof JakartaToJavaxResponseWrapper) {
            SlingJakartaHttpServletResponse initialJakartaResponse = (SlingJakartaHttpServletResponse)((JakartaToJavaxResponseWrapper)response).getResponse();
            SlingJakartaHttpServletResponse entry = this.findOnDemandWriter(initialJakartaResponse);
            if (entry == null) {
                return null;
            }
            if (entry instanceof JakartaToJavaxResponseWrapper) {
                response = (SlingHttpServletResponse)((JakartaToJavaxResponseWrapper)entry).getResponse();
                return this.findOnDemandWriter(response);
            }
        }
        return response;
    }

    private SlingJakartaHttpServletResponse findOnDemandWriter(@NotNull SlingJakartaHttpServletResponse initialResponse) {
        SlingJakartaHttpServletResponse response = initialResponse;
        while (response instanceof SlingJakartaHttpServletResponseWrapper) {
            if (response instanceof OnDemandWriterJakartaResponse) {
                return null;
            }
            response = ((SlingJakartaHttpServletResponseWrapper)response).getSlingResponse();
        }
        if (response instanceof JavaxToJakartaResponseWrapper) {
            SlingHttpServletResponse initialJavaxResponse = (SlingHttpServletResponse)((JavaxToJakartaResponseWrapper)response).getResponse();
            SlingHttpServletResponse entry = this.findOnDemandWriter(initialJavaxResponse);
            if (entry == null) {
                return null;
            }
            if (entry instanceof JakartaToJavaxResponseWrapper) {
                response = (SlingJakartaHttpServletResponse)((JakartaToJavaxResponseWrapper)entry).getResponse();
                return this.findOnDemandWriter(response);
            }
        }
        return response;
    }

    private SlingJakartaHttpServletRequest wrapIfNeeded(@NotNull SlingJakartaHttpServletRequest initialRequest) {
        if (this.findOnDemandReader(initialRequest) == null) {
            return initialRequest;
        }
        return new OnDemandReaderJakartaRequest(initialRequest);
    }

    private SlingJakartaHttpServletResponse wrapIfNeeded(@NotNull SlingJakartaHttpServletResponse initialResponse) {
        if (this.findOnDemandWriter(initialResponse) == null) {
            return initialResponse;
        }
        return new OnDemandWriterJakartaResponse(initialResponse);
    }

    private SlingHttpServletRequest wrapIfNeeded(@NotNull SlingHttpServletRequest initialRequest) {
        if (this.findOnDemandReader(initialRequest) == null) {
            return initialRequest;
        }
        return new OnDemandReaderRequest(initialRequest);
    }

    private SlingHttpServletResponse wrapIfNeeded(@NotNull SlingHttpServletResponse initialResponse) {
        if (this.findOnDemandWriter(initialResponse) == null) {
            return initialResponse;
        }
        return new OnDemandWriterResponse(initialResponse);
    }
}

