/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.caconfig.resource.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.caconfig.management.multiplexer.ConfigurationResourceResolvingStrategyMultiplexer;
import org.apache.sling.caconfig.management.multiplexer.ContextPathStrategyMultiplexer;
import org.apache.sling.caconfig.resource.ConfigurationResourceResolver;
import org.apache.sling.caconfig.resource.impl.util.ConfigNameUtil;
import org.apache.sling.caconfig.resource.spi.ContextResource;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ConfigurationResourceResolver.class}, immediate=true)
public class ConfigurationResourceResolverImpl
implements ConfigurationResourceResolver {
    @Reference
    private ContextPathStrategyMultiplexer contextPathStrategy;
    @Reference
    private ConfigurationResourceResolvingStrategyMultiplexer configurationResourceResolvingStrategy;

    public Resource getResource(@NotNull Resource resource, @NotNull String bucketName, @NotNull String configName) {
        ConfigNameUtil.ensureValidConfigName(configName);
        return this.configurationResourceResolvingStrategy.getResource(resource, Collections.singleton(bucketName), configName);
    }

    @NotNull
    public Collection<Resource> getResourceCollection(@NotNull Resource resource, @NotNull String bucketName, @NotNull String configName) {
        ConfigNameUtil.ensureValidConfigName(configName);
        List<Resource> result = this.configurationResourceResolvingStrategy.getResourceCollection(resource, Collections.singleton(bucketName), configName);
        if (result == null) {
            result = Collections.emptyList();
        }
        return result;
    }

    public String getContextPath(@NotNull Resource resource) {
        Iterator it = this.contextPathStrategy.findContextResources(resource);
        if (it.hasNext()) {
            return ((ContextResource)it.next()).getResource().getPath();
        }
        return null;
    }

    @NotNull
    public Collection<String> getAllContextPaths(@NotNull Resource resource) {
        ArrayList<String> contextPaths = new ArrayList<String>();
        Iterator contextResources = this.contextPathStrategy.findContextResources(resource);
        while (contextResources.hasNext()) {
            contextPaths.add(((ContextResource)contextResources.next()).getResource().getPath());
        }
        return contextPaths;
    }
}

