/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.profile;

import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.apache.skywalking.apm.agent.core.conf.Config;
import org.apache.skywalking.apm.agent.core.context.TracingContext;
import org.apache.skywalking.apm.agent.core.profile.ProfileStatusContext;
import org.apache.skywalking.apm.agent.core.profile.ProfileTask;
import org.apache.skywalking.apm.agent.core.profile.ProfileThread;
import org.apache.skywalking.apm.agent.core.profile.ThreadProfiler;

public class ProfileTaskExecutionContext {
    private final ProfileTask task;
    private final AtomicInteger currentEndpointProfilingCount = new AtomicInteger(0);
    private volatile AtomicReferenceArray<ThreadProfiler> profilingSegmentSlots;
    private volatile Future profilingFuture;
    private final AtomicInteger totalStartedProfilingCount = new AtomicInteger(0);

    public ProfileTaskExecutionContext(ProfileTask task) {
        this.task = task;
        this.profilingSegmentSlots = new AtomicReferenceArray(Config.Profile.MAX_PARALLEL * (Config.Profile.MAX_ACCEPT_SUB_PARALLEL + 1));
    }

    public void startProfiling(ExecutorService executorService) {
        this.profilingFuture = executorService.submit(new ProfileThread(this));
    }

    public void stopProfiling() {
        if (this.profilingFuture != null) {
            this.profilingFuture.cancel(true);
        }
    }

    public ProfileStatusContext attemptProfiling(TracingContext tracingContext, String traceSegmentId, String firstSpanOPName) {
        int profilingEndpointCount = this.currentEndpointProfilingCount.get();
        if (profilingEndpointCount >= Config.Profile.MAX_PARALLEL) {
            return ProfileStatusContext.createWithNone();
        }
        if (!Objects.equals(this.task.getFirstSpanOPName(), firstSpanOPName)) {
            return ProfileStatusContext.createWithNone();
        }
        if (this.totalStartedProfilingCount.get() > this.task.getMaxSamplingCount()) {
            return ProfileStatusContext.createWithNone();
        }
        if (!this.currentEndpointProfilingCount.compareAndSet(profilingEndpointCount, profilingEndpointCount + 1)) {
            return ProfileStatusContext.createWithNone();
        }
        ThreadProfiler profiler = this.addProfilingThread(tracingContext, traceSegmentId);
        if (profiler != null) {
            return profiler.profilingStatus();
        }
        return ProfileStatusContext.createWithNone();
    }

    public boolean continueProfiling(TracingContext tracingContext, String traceSegmentId) {
        return this.addProfilingThread(tracingContext, traceSegmentId) != null;
    }

    private ThreadProfiler addProfilingThread(TracingContext tracingContext, String traceSegmentId) {
        ThreadProfiler threadProfiler = new ThreadProfiler(tracingContext, traceSegmentId, Thread.currentThread(), this);
        int slotLength = this.profilingSegmentSlots.length();
        for (int slot = 0; slot < slotLength; ++slot) {
            if (!this.profilingSegmentSlots.compareAndSet(slot, null, threadProfiler)) continue;
            return threadProfiler;
        }
        return null;
    }

    public void profilingRecheck(TracingContext tracingContext, String traceSegmentId, String firstSpanOPName) {
        if (tracingContext.profileStatus().isBeingWatched()) {
            return;
        }
        tracingContext.profileStatus().updateStatus(this.attemptProfiling(tracingContext, traceSegmentId, firstSpanOPName));
    }

    public void stopTracingProfile(TracingContext tracingContext) {
        int slotLength = this.profilingSegmentSlots.length();
        for (int slot = 0; slot < slotLength; ++slot) {
            ThreadProfiler currentProfiler = this.profilingSegmentSlots.get(slot);
            if (currentProfiler == null || !currentProfiler.matches(tracingContext)) continue;
            this.profilingSegmentSlots.set(slot, null);
            currentProfiler.stopProfiling();
            if (!currentProfiler.profilingStatus().isFromFirstSegment()) break;
            this.currentEndpointProfilingCount.addAndGet(-1);
            break;
        }
    }

    public ProfileTask getTask() {
        return this.task;
    }

    public AtomicReferenceArray<ThreadProfiler> threadProfilerSlots() {
        return this.profilingSegmentSlots;
    }

    public boolean isStartProfileable() {
        return this.totalStartedProfilingCount.incrementAndGet() <= this.task.getMaxSamplingCount();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProfileTaskExecutionContext that = (ProfileTaskExecutionContext)o;
        return Objects.equals(this.task, that.task);
    }

    public int hashCode() {
        return Objects.hash(this.task);
    }
}

