/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.context;

import lombok.Generated;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.CorrelationContext;
import org.apache.skywalking.apm.agent.core.context.ExtensionContext;
import org.apache.skywalking.apm.agent.core.context.ids.DistributedTraceId;
import org.apache.skywalking.apm.agent.core.profile.ProfileStatusContext;

public class ContextSnapshot {
    private DistributedTraceId traceId;
    private String traceSegmentId;
    private int spanId;
    private String parentEndpoint;
    private CorrelationContext correlationContext;
    private ExtensionContext extensionContext;
    private ProfileStatusContext profileStatusContext;

    ContextSnapshot(String traceSegmentId, int spanId, DistributedTraceId primaryTraceId, String parentEndpoint, CorrelationContext correlationContext, ExtensionContext extensionContext, ProfileStatusContext profileStatusContext) {
        this.traceSegmentId = traceSegmentId;
        this.spanId = spanId;
        this.traceId = primaryTraceId;
        this.parentEndpoint = parentEndpoint;
        this.correlationContext = correlationContext.clone();
        this.extensionContext = extensionContext.clone();
        this.profileStatusContext = profileStatusContext.clone();
    }

    public boolean isFromCurrent() {
        return this.traceSegmentId != null && this.traceSegmentId.equals(ContextManager.capture().getTraceSegmentId());
    }

    public CorrelationContext getCorrelationContext() {
        return this.correlationContext;
    }

    public boolean isValid() {
        return this.traceSegmentId != null && this.spanId > -1 && this.traceId != null;
    }

    @Generated
    public DistributedTraceId getTraceId() {
        return this.traceId;
    }

    @Generated
    public String getTraceSegmentId() {
        return this.traceSegmentId;
    }

    @Generated
    public int getSpanId() {
        return this.spanId;
    }

    @Generated
    public String getParentEndpoint() {
        return this.parentEndpoint;
    }

    @Generated
    public ExtensionContext getExtensionContext() {
        return this.extensionContext;
    }

    @Generated
    public ProfileStatusContext getProfileStatusContext() {
        return this.profileStatusContext;
    }
}

