/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.loadbalance;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.loadbalance.Configuration;
import org.apache.servicecomb.loadbalance.LoadBalancer;
import org.apache.servicecomb.loadbalance.RoundRobinRuleExt;
import org.apache.servicecomb.loadbalance.RuleExt;
import org.apache.servicecomb.loadbalance.ServiceCombServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionStickinessRule
implements RuleExt {
    private static final Logger LOG = LoggerFactory.getLogger(SessionStickinessRule.class);
    private final Object lock = new Object();
    private final RuleExt triggerRule = new RoundRobinRuleExt();
    private volatile ServiceCombServer lastServer = null;
    private volatile long lastAccessedTime = 0L;
    private volatile boolean errorThresholdMet = false;
    private static final int MILLI_COUNT_IN_SECOND = 1000;
    private String microserviceName;

    @Override
    public void setLoadBalancer(LoadBalancer loadBalancer) {
        this.microserviceName = loadBalancer.getMicroServiceName();
    }

    private ServiceCombServer chooseNextServer(List<ServiceCombServer> servers, Invocation invocation) {
        this.lastServer = this.triggerRule.choose(servers, invocation);
        this.lastAccessedTime = System.currentTimeMillis();
        return this.lastServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceCombServer chooseInitialServer(List<ServiceCombServer> servers, Invocation invocation) {
        Object object = this.lock;
        synchronized (object) {
            if (this.lastServer == null) {
                this.chooseNextServer(servers, invocation);
            }
        }
        return this.lastServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    ServiceCombServer chooseServerWhenTimeout(List<ServiceCombServer> servers, Invocation invocation) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isTimeOut()) {
                this.chooseNextServer(servers, invocation);
            }
        }
        return this.lastServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceCombServer chooseServerErrorThresholdMet(List<ServiceCombServer> servers, Invocation invocation) {
        Object object = this.lock;
        synchronized (object) {
            if (this.errorThresholdMet) {
                this.chooseNextServer(servers, invocation);
                this.errorThresholdMet = false;
            }
        }
        return this.lastServer;
    }

    private boolean isTimeOut() {
        return Configuration.INSTANCE.getSessionTimeoutInSeconds(this.microserviceName) > 0 && System.currentTimeMillis() - this.lastAccessedTime > (long)Configuration.INSTANCE.getSessionTimeoutInSeconds(this.microserviceName) * 1000L;
    }

    private boolean isErrorThresholdMet(ServiceCombServer server) {
        int successiveFailedCount = server.getServerMetrics().getSnapshot().getNumberOfFailedCalls();
        return Configuration.INSTANCE.getSuccessiveFailedTimes(this.microserviceName) > 0 && successiveFailedCount >= Configuration.INSTANCE.getSuccessiveFailedTimes(this.microserviceName);
    }

    @Override
    public ServiceCombServer choose(List<ServiceCombServer> servers, Invocation invocation) {
        if (this.lastServer == null) {
            return this.chooseInitialServer(servers, invocation);
        }
        if (this.isTimeOut()) {
            LOG.warn("session timeout. choose another server.");
            return this.chooseServerWhenTimeout(servers, invocation);
        }
        this.lastAccessedTime = System.currentTimeMillis();
        if (this.isErrorThresholdMet(this.lastServer)) {
            LOG.warn("reached max error. choose another server.");
            this.errorThresholdMet = true;
            return this.chooseServerErrorThresholdMet(servers, invocation);
        }
        if (!servers.contains(this.lastServer)) {
            return this.chooseNextServer(servers, invocation);
        }
        return this.lastServer;
    }
}

