/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.vertx;

import com.netflix.config.DynamicPropertyFactory;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.metrics.MetricsOptions;
import io.vertx.core.shareddata.Shareable;
import org.apache.servicecomb.foundation.vertx.VertxUtils;
import org.apache.servicecomb.foundation.vertx.metrics.DefaultVertxMetricsFactory;
import org.apache.servicecomb.foundation.vertx.metrics.MetricsOptionsEx;

public class SharedVertxFactory {
    private static final String LOCAL_MAP_NAME = "scb";
    private static final String INFO = "transport-vertx-info";

    public static DefaultVertxMetricsFactory getMetricsFactory() {
        SharedVertxInfo info = (SharedVertxInfo)SharedVertxFactory.getSharedVertx().sharedData().getLocalMap(LOCAL_MAP_NAME).get((Object)INFO);
        return info.metricsFactory;
    }

    public static Vertx getSharedVertx() {
        return VertxUtils.getVertxMap().computeIfAbsent("transport", SharedVertxFactory::createSharedVertx);
    }

    private static Vertx createSharedVertx(String name) {
        SharedVertxInfo info = new SharedVertxInfo();
        Vertx vertx = VertxUtils.init(name, info.vertxOptions);
        info.metricsFactory.setVertx(vertx, info.vertxOptions);
        vertx.sharedData().getLocalMap(LOCAL_MAP_NAME).put((Object)INFO, (Object)info);
        return vertx;
    }

    static class SharedVertxInfo
    implements Shareable {
        public VertxOptions vertxOptions = new VertxOptions();
        public DefaultVertxMetricsFactory metricsFactory = new DefaultVertxMetricsFactory();
        public MetricsOptionsEx metricsOptionsEx = (MetricsOptionsEx)this.metricsFactory.newOptions();

        public SharedVertxInfo() {
            this.vertxOptions.setMetricsOptions((MetricsOptions)this.metricsOptionsEx);
            this.vertxOptions.setEventLoopPoolSize(SharedVertxInfo.readEventLoopPoolSize("servicecomb.transport.eventloop.size"));
        }

        private static int readEventLoopPoolSize(String key) {
            int count = DynamicPropertyFactory.getInstance().getIntProperty(key, -1).get();
            if (count > 0) {
                return count;
            }
            return VertxOptions.DEFAULT_EVENT_LOOP_POOL_SIZE;
        }
    }
}

