/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.huaweicloud.dashboard.monitor;

import com.google.common.eventbus.Subscribe;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.spectator.api.Meter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.servicecomb.dashboard.client.model.InterfaceInfo;
import org.apache.servicecomb.dashboard.client.model.MonitorData;
import org.apache.servicecomb.foundation.common.event.EventManager;
import org.apache.servicecomb.foundation.metrics.PolledEvent;
import org.apache.servicecomb.huaweicloud.dashboard.monitor.model.MonitorDataProvider;
import org.apache.servicecomb.metrics.core.publish.PublishModelFactory;
import org.apache.servicecomb.metrics.core.publish.model.DefaultPublishModel;
import org.apache.servicecomb.metrics.core.publish.model.invocation.OperationPerf;
import org.apache.servicecomb.metrics.core.publish.model.invocation.OperationPerfGroup;
import org.apache.servicecomb.metrics.core.publish.model.invocation.OperationPerfGroups;
import org.apache.servicecomb.metrics.core.publish.model.invocation.PerfInfo;

public class MetricsMonitorDataProvider
implements MonitorDataProvider {
    public static final String CODE_SUCCESS = "2[0-9]{2}";
    public static final String CODE_TIMEOUT = "408";
    public static final String NAME_PROVIDER = "Provider.";
    public static final String NAME_CONSUMER = "Consumer.";
    private volatile List<Meter> meters = null;

    public MetricsMonitorDataProvider() {
        EventManager.register((Object)this);
    }

    @Override
    public boolean enabled() {
        return DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.monitor.provider.metrics.enabled", true).get();
    }

    @Override
    public void extractInterfaceInfo(MonitorData monitorData) {
        if (this.meters == null) {
            return;
        }
        PublishModelFactory factory = new PublishModelFactory(this.meters);
        DefaultPublishModel model = factory.createDefaultPublishModel();
        HashMap<String, InterfaceInfo> combinedResults = new HashMap<String, InterfaceInfo>();
        this.extractProviderInfo(model, combinedResults);
        this.extractConsumerInfo(model, combinedResults);
        this.extractEdgeInfo(model, combinedResults);
        combinedResults.forEach((k, v) -> {
            v.setFailureRate(v.getTotal() == 0L ? 0.0 : (double)v.getFailure() / (double)v.getTotal());
            monitorData.addInterfaceInfo(v);
        });
    }

    private void extractProviderInfo(DefaultPublishModel model, Map<String, InterfaceInfo> combinedResults) {
        OperationPerfGroups producerPerf = model.getProducer().getOperationPerfGroups();
        if (producerPerf == null) {
            return;
        }
        for (Map statusMap : producerPerf.getGroups().values()) {
            for (OperationPerfGroup perfGroup : statusMap.values()) {
                for (int i = 0; i < perfGroup.getOperationPerfs().size(); ++i) {
                    OperationPerf operationPerf = (OperationPerf)perfGroup.getOperationPerfs().get(i);
                    PerfInfo stageTotal = operationPerf.findStage("total");
                    String name = NAME_PROVIDER + operationPerf.getOperation();
                    InterfaceInfo interfaceInfo = combinedResults.computeIfAbsent(name, k -> {
                        InterfaceInfo obj = new InterfaceInfo();
                        obj.setName(name);
                        return obj;
                    });
                    interfaceInfo.setTotal((long)this.doubleToInt((double)interfaceInfo.getTotal() + 10.0 * stageTotal.getTps()));
                    if (perfGroup.getStatus().matches(CODE_SUCCESS)) {
                        interfaceInfo.setQps(stageTotal.getTps());
                        interfaceInfo.setLatency(this.doubleToInt(stageTotal.calcMsLatency()));
                        continue;
                    }
                    interfaceInfo.setFailure((long)this.doubleToInt((double)interfaceInfo.getTotal() + stageTotal.getMsTotalTime() * stageTotal.getTps()));
                    if (!perfGroup.getStatus().equals(CODE_TIMEOUT)) continue;
                    interfaceInfo.setCountTimeout((long)this.doubleToInt((double)interfaceInfo.getCountTimeout() + stageTotal.getMsTotalTime() * stageTotal.getTps()));
                }
            }
        }
    }

    private void extractEdgeInfo(DefaultPublishModel model, Map<String, InterfaceInfo> combinedResults) {
        OperationPerfGroups edgePerf = model.getEdge().getOperationPerfGroups();
        if (edgePerf == null) {
            return;
        }
        for (Map statusMap : edgePerf.getGroups().values()) {
            for (OperationPerfGroup perfGroup : statusMap.values()) {
                for (int i = 0; i < perfGroup.getOperationPerfs().size(); ++i) {
                    OperationPerf operationPerf = (OperationPerf)perfGroup.getOperationPerfs().get(i);
                    PerfInfo stageTotal = operationPerf.findStage("total");
                    String name = NAME_CONSUMER + operationPerf.getOperation();
                    InterfaceInfo interfaceInfo = combinedResults.computeIfAbsent(name, k -> {
                        InterfaceInfo obj = new InterfaceInfo();
                        obj.setName(name);
                        return obj;
                    });
                    interfaceInfo.setTotal((long)this.doubleToInt((double)interfaceInfo.getTotal() + 10.0 * stageTotal.getTps()));
                    if (perfGroup.getStatus().matches(CODE_SUCCESS)) {
                        interfaceInfo.setQps(stageTotal.getTps());
                        interfaceInfo.setLatency(this.doubleToInt(stageTotal.calcMsLatency()));
                        continue;
                    }
                    interfaceInfo.setFailure((long)this.doubleToInt((double)interfaceInfo.getTotal() + stageTotal.getMsTotalTime() * stageTotal.getTps()));
                    if (!perfGroup.getStatus().equals(CODE_TIMEOUT)) continue;
                    interfaceInfo.setCountTimeout((long)this.doubleToInt((double)interfaceInfo.getCountTimeout() + stageTotal.getMsTotalTime() * stageTotal.getTps()));
                }
            }
        }
    }

    private void extractConsumerInfo(DefaultPublishModel model, Map<String, InterfaceInfo> combinedResults) {
        OperationPerfGroups consumerPerf = model.getConsumer().getOperationPerfGroups();
        if (consumerPerf == null) {
            return;
        }
        for (Map statusMap : consumerPerf.getGroups().values()) {
            for (OperationPerfGroup perfGroup : statusMap.values()) {
                for (int i = 0; i < perfGroup.getOperationPerfs().size(); ++i) {
                    OperationPerf operationPerf = (OperationPerf)perfGroup.getOperationPerfs().get(i);
                    PerfInfo stageTotal = operationPerf.findStage("total");
                    String name = NAME_CONSUMER + operationPerf.getOperation();
                    InterfaceInfo interfaceInfo = combinedResults.computeIfAbsent(name, k -> {
                        InterfaceInfo obj = new InterfaceInfo();
                        obj.setName(name);
                        return obj;
                    });
                    interfaceInfo.setTotal((long)this.doubleToInt((double)interfaceInfo.getTotal() + 10.0 * stageTotal.getTps()));
                    if (perfGroup.getStatus().matches(CODE_SUCCESS)) {
                        interfaceInfo.setQps(stageTotal.getTps());
                        interfaceInfo.setLatency(this.doubleToInt(stageTotal.calcMsLatency()));
                        continue;
                    }
                    interfaceInfo.setFailure((long)this.doubleToInt((double)interfaceInfo.getTotal() + stageTotal.getMsTotalTime() * stageTotal.getTps()));
                    if (!perfGroup.getStatus().equals(CODE_TIMEOUT)) continue;
                    interfaceInfo.setCountTimeout((long)this.doubleToInt((double)interfaceInfo.getCountTimeout() + stageTotal.getMsTotalTime() * stageTotal.getTps()));
                }
            }
        }
    }

    private int doubleToInt(Double d) {
        return d.intValue();
    }

    @Subscribe
    public void onPolledEvent(PolledEvent event) {
        this.meters = event.getMeters();
    }
}

