/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.modules.languages.apacheconf.lexer;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.lexer.Token;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerRestartInfo;
import org.netbeans.spi.lexer.TokenFactory;

/**
 *
 * @author Ondrej Brejla <obrejla@netbeans.org>
 */
public class ApacheConfLexer implements Lexer<ApacheConfTokenId> {

    private final ApacheConfColoringLexer scanner;
    private final TokenFactory<ApacheConfTokenId> tokenFactory;

    public static synchronized ApacheConfLexer create(LexerRestartInfo<ApacheConfTokenId> info) {
        return new ApacheConfLexer(info);
    }

    public ApacheConfLexer(LexerRestartInfo<ApacheConfTokenId> info) {
        scanner = new ApacheConfColoringLexer(info);
        tokenFactory = info.tokenFactory();
    }

    @Override
    public Token<ApacheConfTokenId> nextToken() {
        try {
            ApacheConfTokenId tokenId = scanner.nextToken();
            Token<ApacheConfTokenId> token = null;
            if (tokenId != null) {
                token = tokenFactory.createToken(tokenId);
            }
            return token;
        } catch (IOException ex) {
            Logger.getLogger(ApacheConfLexer.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }

    @Override
    public Object state() {
        return scanner.getState();
    }

    @Override
    public void release() {
    }

}
