/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.filter;

import java.io.IOException;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.chemistry.opencmis.server.filter.ProxyHttpServletRequestWrapper;

public class ProxyFilter
implements Filter {
    public static final String PARAM_BASE_PATH = "basePath";
    public static final String PARAM_TRUSTED_PROXIES = "trustedProxies";
    private String basePath;
    private Pattern trustedProxies;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.basePath = filterConfig.getInitParameter(PARAM_BASE_PATH);
        this.trustedProxies = null;
        String trustedProxiesString = filterConfig.getInitParameter(PARAM_TRUSTED_PROXIES);
        if (trustedProxiesString != null) {
            try {
                this.trustedProxies = Pattern.compile(trustedProxiesString);
            }
            catch (Exception e) {
                throw new ServletException("Could not compile trustedProxies parameter: " + e, (Throwable)e);
            }
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.trustedProxies != null && request instanceof HttpServletRequest && this.trustedProxies.matcher(request.getRemoteAddr()).matches()) {
            request = new ProxyHttpServletRequestWrapper((HttpServletRequest)request, this.basePath);
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

