/*
 * Decompiled with CFR 0.152.
 */
package jodd.util.function;

import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;

public interface Maybe<T>
extends Iterable<T> {
    public static <T> Maybe<T> of(T value) {
        if (value == null) {
            return Maybe.nothing();
        }
        return Maybe.just(value);
    }

    public static <T> Maybe<T> of(Optional<T> optionalValue) {
        return optionalValue.map(Maybe::of).orElseGet(Maybe::nothing);
    }

    public boolean isJust();

    public boolean isNothing();

    public <V> V maybe(V var1, Function<T, V> var2);

    public void consumeJust(Consumer<T> var1);

    public Stream<T> stream();

    public Maybe<T> or(T var1);

    public Maybe<T> or(Maybe<T> var1);

    public Maybe<T> or(Supplier<? extends Maybe<? extends T>> var1);

    public <U> Maybe<U> map(Function<? super T, ? extends U> var1);

    public <U> Maybe<U> flatMap(Function<? super T, Maybe<U>> var1);

    public Maybe<T> filter(Predicate<? super T> var1);

    public Optional<T> optional();

    public static <T> Maybe<T> nothing() {
        return new Maybe<T>(){

            @Override
            public boolean isJust() {
                return false;
            }

            @Override
            public boolean isNothing() {
                return true;
            }

            @Override
            public <V> V maybe(V defaultValue, Function<T, V> function) {
                return defaultValue;
            }

            @Override
            public void consumeJust(Consumer<T> consumer) {
            }

            @Override
            public Iterator<T> iterator() {
                return Collections.emptyList().iterator();
            }

            @Override
            public Stream<T> stream() {
                return Stream.empty();
            }

            @Override
            public Maybe<T> or(T otherValue) {
                return Maybe.of(otherValue);
            }

            @Override
            public Maybe<T> or(Maybe<T> maybeJust) {
                return maybeJust;
            }

            @Override
            public Maybe<T> or(Supplier<? extends Maybe<? extends T>> supplier) {
                Maybe r = supplier.get();
                return Objects.requireNonNull(r);
            }

            @Override
            public <U> Maybe<U> map(Function<? super T, ? extends U> mapper) {
                return Maybe.nothing();
            }

            @Override
            public <U> Maybe<U> flatMap(Function<? super T, Maybe<U>> mapper) {
                return Maybe.nothing();
            }

            @Override
            public Maybe<T> filter(Predicate<? super T> mapping) {
                return Maybe.nothing();
            }

            public String toString() {
                return "nothing";
            }

            public boolean equals(Object obj) {
                return false;
            }

            public int hashCode() {
                return 0;
            }

            @Override
            public Optional<T> optional() {
                return Optional.empty();
            }
        };
    }

    public static <T> Maybe<T> just(T theValue) {
        return new Just(theValue);
    }

    public static class Just<T>
    implements Maybe<T> {
        private final T value;

        private Just(T value) {
            Objects.requireNonNull(value);
            this.value = value;
        }

        @Override
        public boolean isJust() {
            return true;
        }

        @Override
        public boolean isNothing() {
            return false;
        }

        @Override
        public <V> V maybe(V defaultValue, Function<T, V> function) {
            return function.apply(this.value);
        }

        @Override
        public void consumeJust(Consumer<T> consumer) {
            consumer.accept(this.value);
        }

        @Override
        public Iterator<T> iterator() {
            return Collections.singleton(this.value).iterator();
        }

        @Override
        public Stream<T> stream() {
            return Stream.of(this.value);
        }

        @Override
        public Maybe<T> or(T otherValue) {
            return this;
        }

        @Override
        public Maybe<T> or(Maybe<T> maybeDefaultValue) {
            return this;
        }

        @Override
        public Maybe<T> or(Supplier<? extends Maybe<? extends T>> supplier) {
            return this;
        }

        @Override
        public <U> Maybe<U> map(Function<? super T, ? extends U> mapper) {
            return Maybe.of(mapper.apply(this.value));
        }

        @Override
        public <U> Maybe<U> flatMap(Function<? super T, Maybe<U>> mapper) {
            return mapper.apply(this.value);
        }

        @Override
        public Maybe<T> filter(Predicate<? super T> predicate) {
            return predicate.test(this.value) ? this : Maybe.nothing();
        }

        public String toString() {
            return "just: " + this.value.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Just that = (Just)o;
            return this.value.equals(that.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        @Override
        public Optional<T> optional() {
            return Optional.of(this.value);
        }
    }
}

