/*
 * Decompiled with CFR 0.152.
 */
package org.jCharts.encoders;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpServletResponse;
import org.jCharts.Chart;
import org.jCharts.chartData.ChartDataException;
import org.jCharts.encoders.JPEGEncoder;
import org.jCharts.encoders.JPEGEncoder13;
import org.jCharts.encoders.PNGEncoder;
import org.jCharts.encoders.SVGEncoder;
import org.jCharts.properties.PropertyException;

public class ServletEncoderHelper {
    public static final String SVG_MIME_TYPE = "image/svg+xml";
    public static final String PNG_MIME_TYPE = "image/png";
    public static final String JPEG_MIME_TYPE = "image/jpeg";

    public static final void encodeServlet(Chart chart, HttpServletResponse httpServletResponse) throws ChartDataException, PropertyException, IOException {
        httpServletResponse.setContentType(SVG_MIME_TYPE);
        SVGEncoder.encode(chart, (OutputStream)httpServletResponse.getOutputStream());
    }

    public static final void encodeJPEG13(Chart chart, float f, HttpServletResponse httpServletResponse) throws ChartDataException, PropertyException, IOException {
        httpServletResponse.setContentType(JPEG_MIME_TYPE);
        JPEGEncoder13.encode(chart, f, (OutputStream)httpServletResponse.getOutputStream());
    }

    public static final void encodeJPEG(Chart chart, float f, HttpServletResponse httpServletResponse) throws ChartDataException, PropertyException, IOException {
        httpServletResponse.setContentType(JPEG_MIME_TYPE);
        JPEGEncoder.encode(chart, f, (OutputStream)httpServletResponse.getOutputStream());
    }

    public static final void encodePNG(Chart chart, HttpServletResponse httpServletResponse) throws ChartDataException, PropertyException, IOException {
        httpServletResponse.setContentType(PNG_MIME_TYPE);
        PNGEncoder.encode(chart, (OutputStream)httpServletResponse.getOutputStream());
    }
}

