/*
 * Decompiled with CFR 0.152.
 */
package org.jCharts.axisChart;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import org.jCharts.axisChart.AxisChart;
import org.jCharts.axisChart.BarChart;
import org.jCharts.chartData.ChartDataException;
import org.jCharts.chartData.interfaces.IAxisChartDataSet;
import org.jCharts.imageMap.RectMapArea;
import org.jCharts.properties.DataAxisProperties;
import org.jCharts.properties.StackedBarChartProperties;

abstract class StackedBarChart {
    StackedBarChart() {
    }

    static void render(AxisChart axisChart, IAxisChartDataSet iAxisChartDataSet) throws ChartDataException {
        Graphics2D graphics2D = axisChart.getGraphics2D();
        StackedBarChartProperties stackedBarChartProperties = (StackedBarChartProperties)iAxisChartDataSet.getChartTypeProperties();
        if (axisChart.getAxisProperties().isPlotHorizontal()) {
            DataAxisProperties dataAxisProperties = (DataAxisProperties)axisChart.getAxisProperties().getXAxisProperties();
            float f = axisChart.getYAxis().getScalePixelWidth() * stackedBarChartProperties.getPercentage();
            float f2 = axisChart.getXAxis().getZeroLineCoordinate();
            float f3 = axisChart.getYAxis().getLastTickY() - f / 2.0f;
            float f4 = 0.0f;
            float f5 = f;
            Rectangle2D.Float float_ = new Rectangle2D.Float(f2, f3, f4, f5);
            StackedBarChart.horizontalPlot(axisChart, iAxisChartDataSet, stackedBarChartProperties, dataAxisProperties, graphics2D, float_, f2);
        } else {
            DataAxisProperties dataAxisProperties = (DataAxisProperties)axisChart.getAxisProperties().getYAxisProperties();
            float f = axisChart.getXAxis().getScalePixelWidth() * stackedBarChartProperties.getPercentage();
            float f6 = axisChart.getXAxis().getTickStart() - f / 2.0f;
            float f7 = axisChart.getYAxis().getZeroLineCoordinate();
            float f8 = f;
            float f9 = 0.0f;
            Rectangle2D.Float float_ = new Rectangle2D.Float(f6, f7, f8, f9);
            StackedBarChart.verticalPlot(axisChart, iAxisChartDataSet, stackedBarChartProperties, dataAxisProperties, graphics2D, float_, f7);
        }
    }

    private static void horizontalPlot(AxisChart axisChart, IAxisChartDataSet iAxisChartDataSet, StackedBarChartProperties stackedBarChartProperties, DataAxisProperties dataAxisProperties, Graphics2D graphics2D, Rectangle2D.Float float_, float f) throws ChartDataException {
        int n = axisChart.getYAxis().getNumberOfScaleItems() - 1;
        int n2 = 0;
        while (n2 < iAxisChartDataSet.getNumberOfDataItems()) {
            int n3 = 0;
            while (n3 < iAxisChartDataSet.getNumberOfDataSets()) {
                if (iAxisChartDataSet.getValue(n3, n2) != 0.0) {
                    if (iAxisChartDataSet.getValue(n3, n2) < 0.0) {
                        throw new ChartDataException("Negative values in Stacked Bar charts are not supported yet... Coming soon...");
                    }
                    float_.width = BarChart.computeScaleHeightOfValue(iAxisChartDataSet.getValue(n3, n2), axisChart.getXAxis().getOneUnitPixelSize());
                    graphics2D.setPaint(iAxisChartDataSet.getPaint(n3));
                    graphics2D.fill(float_);
                    if (stackedBarChartProperties.getShowOutlinesFlag()) {
                        stackedBarChartProperties.getBarOutlineStroke().draw(graphics2D, float_);
                    }
                    if (axisChart.getGenerateImageMapFlag()) {
                        String string = null;
                        if (axisChart.getYAxis().getAxisLabelsGroup() != null) {
                            string = axisChart.getYAxis().getAxisLabelsGroup().getTextTag(n).getText();
                        }
                        axisChart.getImageMap().addImageMapArea(new RectMapArea(float_, iAxisChartDataSet.getValue(n3, n2), string, iAxisChartDataSet.getLegendLabel(n3)));
                    }
                    float_.x += float_.width;
                }
                ++n3;
            }
            --n;
            float_.y += axisChart.getYAxis().getScalePixelWidth();
            float_.x = f;
            ++n2;
        }
    }

    private static void verticalPlot(AxisChart axisChart, IAxisChartDataSet iAxisChartDataSet, StackedBarChartProperties stackedBarChartProperties, DataAxisProperties dataAxisProperties, Graphics2D graphics2D, Rectangle2D.Float float_, float f) {
        int n = 0;
        while (n < iAxisChartDataSet.getNumberOfDataItems()) {
            int n2 = 0;
            while (n2 < iAxisChartDataSet.getNumberOfDataSets()) {
                if (iAxisChartDataSet.getValue(n2, n) != 0.0) {
                    float_.height = BarChart.computeScaleHeightOfValue(iAxisChartDataSet.getValue(n2, n), axisChart.getYAxis().getOneUnitPixelSize());
                    float_.y -= float_.height;
                    graphics2D.setPaint(iAxisChartDataSet.getPaint(n2));
                    graphics2D.fill(float_);
                    if (stackedBarChartProperties.getShowOutlinesFlag()) {
                        stackedBarChartProperties.getBarOutlineStroke().draw(graphics2D, float_);
                    }
                    if (axisChart.getGenerateImageMapFlag()) {
                        String string = null;
                        if (axisChart.getXAxis().getAxisLabelsGroup() != null) {
                            string = axisChart.getXAxis().getAxisLabelsGroup().getTextTag(n).getText();
                        }
                        axisChart.getImageMap().addImageMapArea(new RectMapArea(float_, iAxisChartDataSet.getValue(n2, n), string, iAxisChartDataSet.getLegendLabel(n2)));
                    }
                }
                ++n2;
            }
            float_.x += axisChart.getXAxis().getScalePixelWidth();
            float_.y = f;
            ++n;
        }
    }
}

