/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.splitpane;

import com.github.weisj.darklaf.delegate.LayoutManagerDelegate;
import com.github.weisj.darklaf.ui.splitpane.DarkNonContinuousSplitPaneDivider;
import com.github.weisj.darklaf.ui.splitpane.DarkSplitPaneDivider;
import com.github.weisj.darklaf.ui.splitpane.DividerStyle;
import com.github.weisj.darklaf.ui.splitpane.SplitPaneConstants;
import com.github.weisj.darklaf.ui.splitpane.ThinSplitPaneDivider;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class DarkSplitPaneUI
extends BasicSplitPaneUI
implements PropertyChangeListener,
SplitPaneConstants {
    private static final int DIVIDER_DRAG_SIZE = 10;
    private static final int DIVIDER_DRAG_OFFSET = 5;
    private DividerStyle style;
    private Color dividerLine;

    protected DarkSplitPaneUI(DividerStyle style) {
        this.style = style;
    }

    public static ComponentUI createUI(JComponent c) {
        return new DarkSplitPaneUI(DividerStyle.get(UIManager.getString("SplitPane.defaultDividerStyle")));
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.splitPane.setContinuousLayout(true);
        this.splitPane.setComponentZOrder(this.getDivider(), 0);
    }

    @Override
    protected void installDefaults() {
        DividerStyle oldStyle = DividerStyle.getNullableStyle(this.splitPane.getClientProperty("JSplitPane.style"));
        if (oldStyle != null) {
            this.style = oldStyle;
        }
        super.installDefaults();
        this.dividerLine = UIManager.getColor("SplitPane.dividerLineColor");
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.splitPane.addPropertyChangeListener(this);
    }

    @Override
    public void uninstallUI(JComponent c) {
        if (this.splitPane.getLayout() instanceof LayoutManagerDelegate) {
            this.splitPane.setLayout(null);
        }
        super.uninstallUI(c);
        this.divider = null;
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.splitPane.removePropertyChangeListener(this);
    }

    @Override
    public BasicSplitPaneDivider createDefaultDivider() {
        if (!this.style.isThin()) {
            return new DarkSplitPaneDivider(this);
        }
        return new ThinSplitPaneDivider(this);
    }

    @Override
    protected Component createDefaultNonContinuousLayoutDivider() {
        return new DarkNonContinuousSplitPaneDivider(this);
    }

    @Override
    public void finishedPaintingChildren(JSplitPane sp, Graphics g) {
        int lastDragLocation = this.getLastDragLocation();
        if (sp == this.splitPane && lastDragLocation != -1 && !this.isContinuousLayout() && !this.draggingHW) {
            Dimension size = this.splitPane.getSize();
            Component divider = this.getNonContinuousLayoutDivider();
            Rectangle dividerBounds = divider.getBounds();
            int x = 0;
            int y = 0;
            if (this.getOrientation() == 1) {
                x = lastDragLocation;
                divider.setSize(this.getDivider().getWidth(), size.height);
            } else {
                y = lastDragLocation;
                divider.setSize(size.width, this.getDivider().getHeight());
            }
            g.translate(x, y);
            divider.paint(g);
            divider.setBounds(dividerBounds);
            g.translate(-x, -y);
        }
    }

    @Override
    protected void resetLayoutManager() {
        super.resetLayoutManager();
        this.splitPane.setLayout(new LayoutManagerDelegate(this.splitPane.getLayout()){

            @Override
            public void layoutContainer(Container parent) {
                super.layoutContainer(parent);
                if (DarkSplitPaneUI.this.style.isThin()) {
                    Rectangle bounds = DarkSplitPaneUI.this.getDivider().getBounds();
                    if (DarkSplitPaneUI.this.getOrientation() == 1) {
                        bounds.x -= 5;
                        bounds.width = 10;
                    } else {
                        bounds.y -= 5;
                        bounds.height = 10;
                    }
                    DarkSplitPaneUI.this.getDivider().setBounds(bounds);
                }
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String key = evt.getPropertyName();
        if ("JSplitPane.style".equals(key)) {
            Object val = evt.getNewValue();
            DividerStyle oldStyle = this.style;
            this.style = DividerStyle.get(val);
            if (oldStyle != this.style) {
                if (oldStyle.isThin() != this.style.isThin()) {
                    this.splitPane.setUI(new DarkSplitPaneUI(this.style));
                    return;
                }
                this.splitPane.doLayout();
            }
            this.splitPane.repaint();
        } else if ("orientation".equals(key)) {
            this.splitPane.revalidate();
        }
    }

    public Color getDividerLineColor() {
        return this.dividerLine;
    }

    public int getDividerDragOffset() {
        return 5;
    }

    public int getDividerDragSize() {
        return 10;
    }

    public DividerStyle getStyle() {
        return this.style;
    }

    @Override
    public int getMinimumDividerLocation(JSplitPane jc) {
        int loc = super.getMinimumDividerLocation(jc);
        if (this.getDivider() instanceof ThinSplitPaneDivider) {
            loc += this.getDividerDragOffset();
        }
        return loc;
    }
}

