/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.components.tristate;

import com.github.weisj.darklaf.LafManager;
import com.github.weisj.darklaf.components.tristate.TristateButtonModel;
import com.github.weisj.darklaf.components.tristate.TristateState;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.event.ChangeListener;

public class TristateCheckBox
extends JCheckBox {
    private final ChangeListener enableListener = e -> this.setFocusable(this.getModel().isEnabled());

    public TristateCheckBox() {
        this((String)null);
    }

    public TristateCheckBox(String text) {
        this(text, null, TristateState.DESELECTED);
    }

    public TristateCheckBox(String text, Icon icon, TristateState initial) {
        super(text, icon);
        this.setModel(new TristateButtonModel(initial));
        this.addActionListener(e -> this.iterateState());
    }

    private void iterateState() {
        if (!this.getModel().isEnabled()) {
            return;
        }
        this.getTristateModel().iterateState();
    }

    public TristateButtonModel getTristateModel() {
        return (TristateButtonModel)super.getModel();
    }

    @Override
    public String getUIClassID() {
        if (LafManager.isInstalled()) {
            return "TristateCheckBoxUI";
        }
        return super.getUIClassID();
    }

    public boolean allowsIndeterminate() {
        return this.getTristateModel().allowsIndeterminate();
    }

    public void setAllowsIndeterminate(boolean allowsIndeterminate) {
        this.getTristateModel().setAllowsIndeterminate(allowsIndeterminate);
    }

    @Override
    public void setSelected(boolean b) {
        this.setState(b ? TristateState.SELECTED : TristateState.DESELECTED);
    }

    @Override
    public void setModel(ButtonModel newModel) {
        ButtonModel model = this.getModel();
        if (model instanceof TristateButtonModel) {
            model.removeChangeListener(this.enableListener);
        }
        super.setModel(newModel);
        if (model instanceof TristateButtonModel) {
            model.addChangeListener(this.enableListener);
        }
    }

    public void setIndeterminate() {
        this.getTristateModel().setIndeterminate();
    }

    public boolean isIndeterminate() {
        return this.getTristateModel().isIndeterminate();
    }

    public TristateState getState() {
        return this.getTristateModel().getState();
    }

    public void setState(TristateState state) {
        this.getTristateModel().setState(state);
    }
}

