/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.components.treetable.model;

import com.github.weisj.darklaf.components.treetable.model.TreeTableNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DefaultTreeTableNode
implements TreeTableNode {
    private final List<TreeTableNode> children;
    private final TreeTableNode parent;
    private final List<Object> columns;

    public DefaultTreeTableNode(TreeTableNode parent, Object[] columns) {
        this(parent, Arrays.asList(columns));
    }

    public DefaultTreeTableNode(TreeTableNode parent, List<Object> columns) {
        this.parent = parent;
        this.columns = columns;
        this.children = new ArrayList<TreeTableNode>();
    }

    @Override
    public List<TreeTableNode> getChildren() {
        return this.children;
    }

    @Override
    public TreeTableNode getParent() {
        return this.parent;
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    public void addChild(TreeTableNode child) {
        this.children.add(child);
    }

    public void removeChild(TreeTableNode child) {
        this.children.remove(child);
    }

    public String toString() {
        return this.getTreeValue().toString();
    }

    @Override
    public List<Object> getColumns() {
        return this.columns;
    }
}

