/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.components.tabframe;

import com.github.weisj.darklaf.components.tabframe.PanelPopup;
import com.github.weisj.darklaf.components.tabframe.TabFrameTabbedPopupUI;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JTabbedPane;
import javax.swing.plaf.PanelUI;

public class TabbedPopup
extends PanelPopup {
    private JTabbedPane tabbedPane;

    public TabbedPopup(String title) {
        this(title, null, null);
    }

    public TabbedPopup(String title, Icon icon, Component content) {
        super(title, icon, content);
        this.setIcon(icon);
        this.setTitle(title);
        this.setContentPane(content);
        this.setEnabled(false);
    }

    public TabbedPopup(String title, Icon icon) {
        this(title, icon, null);
    }

    public TabbedPopup(String title, Component content) {
        this(title, null, content);
    }

    protected JTabbedPane createTabbedPane() {
        return this.getPopupUI().createTabbedPane();
    }

    public JTabbedPane getTabbedPane() {
        if (this.tabbedPane == null) {
            this.tabbedPane = this.createTabbedPane();
        }
        return this.tabbedPane;
    }

    @Override
    public String getUIClassID() {
        return "TabFrameTabbedPopupUI";
    }

    @Override
    public void setUI(PanelUI ui) {
        if (!(ui instanceof TabFrameTabbedPopupUI)) {
            throw new IllegalArgumentException("Ui needs to be of type " + TabFrameTabbedPopupUI.class);
        }
        super.setUI(ui);
    }

    @Override
    public TabFrameTabbedPopupUI getPopupUI() {
        return (TabFrameTabbedPopupUI)super.getPopupUI();
    }

    @Override
    public Component getContentPane() {
        return this.tabbedPane.getSelectedComponent();
    }

    @Override
    public void setContentPane(Component component) {
        if (component == null) {
            return;
        }
        if (this.getContentPanes().contains(component)) {
            return;
        }
        this.getTabbedPane().addTab(component.getName(), component);
    }

    public Collection<Component> getContentPanes() {
        int size = this.getTabbedPane().getTabCount();
        ArrayList<Component> compList = new ArrayList<Component>(size);
        for (int i = 0; i < size; ++i) {
            compList.add(this.tabbedPane.getComponentAt(i));
        }
        return compList;
    }
}

