/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.extractor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.jmeter.processor.PostProcessor;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.AbstractScopedTestElement;
import org.apache.jmeter.testelement.property.IntegerProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.util.Document;
import org.apache.jmeter.util.JMeterUtils;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoundaryExtractor
extends AbstractScopedTestElement
implements PostProcessor,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(BoundaryExtractor.class);
    private static final long serialVersionUID = 2L;
    private static final String REFNAME = "BoundaryExtractor.refname";
    private static final String MATCH_NUMBER = "BoundaryExtractor.match_number";
    private static final String L_BOUNDARY = "BoundaryExtractor.lboundary";
    private static final String R_BOUNDARY = "BoundaryExtractor.rboundary";
    private static final String DEFAULT_EMPTY_VALUE = "BoundaryExtractor.default_empty_value";
    private static final String DEFAULT = "BoundaryExtractor.default";
    private static final String REF_MATCH_NR = "_matchNr";
    private static final char UNDERSCORE = '_';
    private static final String MATCH_AGAINST = "BoundaryExtractor.useHeaders";
    private static final String USE_HDRS = "true";
    private static final String USE_REQUEST_HDRS = "request_headers";
    private static final String USE_BODY = "false";
    private static final String USE_BODY_UNESCAPED = "unescaped";
    private static final String USE_BODY_AS_DOCUMENT = "as_document";
    private static final String USE_URL = "URL";
    private static final String USE_CODE = "code";
    private static final String USE_MESSAGE = "message";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() {
        JMeterContext context = this.getThreadContext();
        SampleResult previousResult = context.getPreviousResult();
        if (previousResult == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Boundary Extractor {}: processing result", (Object)this.getName());
        }
        if (StringUtils.isEmpty((CharSequence)this.getRefName())) {
            throw new IllegalArgumentException("One of the mandatory properties is missing in Boundary Extractor:" + this.getName());
        }
        JMeterVariables vars = context.getVariables();
        String refName = this.getRefName();
        String defaultValue = this.getDefaultValue();
        if (StringUtils.isNotBlank((CharSequence)defaultValue) || this.isEmptyDefaultValue()) {
            vars.put(refName, defaultValue);
        }
        int matchNumber = this.getMatchNumber();
        int prevCount = 0;
        int matchCount = 0;
        try {
            prevCount = this.removePrevCount(vars, refName);
            List<String> matches = this.extractMatches(previousResult, vars, matchNumber);
            matchCount = BoundaryExtractor.saveMatches(vars, refName, matchNumber, matches);
        }
        catch (RuntimeException e) {
            if (log.isWarnEnabled()) {
                log.warn("{}: Error while generating result. {}", (Object)this.getName(), (Object)e.toString());
            }
        }
        finally {
            for (int i = matchCount + 1; i <= prevCount; ++i) {
                vars.remove(refName + '_' + i);
            }
        }
    }

    private int removePrevCount(JMeterVariables vars, String refName) {
        int prevCount;
        block3: {
            prevCount = 0;
            String prevString = vars.get(refName + REF_MATCH_NR);
            if (prevString != null) {
                vars.remove(refName + REF_MATCH_NR);
                try {
                    prevCount = Integer.parseInt(prevString);
                }
                catch (NumberFormatException nfe) {
                    if (!log.isWarnEnabled()) break block3;
                    log.warn("{}: Could not parse number: '{}'.", (Object)this.getName(), (Object)prevString);
                }
            }
        }
        return prevCount;
    }

    private List<String> extractMatches(SampleResult previousResult, JMeterVariables vars, int matchNumber) {
        if (this.isScopeVariable()) {
            String inputString = vars.get(this.getVariableName());
            if (inputString == null && log.isWarnEnabled()) {
                log.warn("No variable '{}' found to process by Boundary Extractor '{}', skipping processing", (Object)this.getVariableName(), (Object)this.getName());
            }
            return BoundaryExtractor.extract(this.getLeftBoundary(), this.getRightBoundary(), matchNumber, inputString);
        }
        Stream<String> inputs = this.getSampleList(previousResult).stream().map(this::getInputString);
        return BoundaryExtractor.extract(this.getLeftBoundary(), this.getRightBoundary(), matchNumber, inputs);
    }

    private static int saveMatches(JMeterVariables vars, String refName, int matchNumber, List<String> matches) {
        if (matchNumber >= 0 && matches.isEmpty()) {
            return 0;
        }
        int matchCount = 0;
        if (matchNumber == 0) {
            BoundaryExtractor.saveRandomMatch(vars, refName, matches);
        } else if (matchNumber > 0) {
            BoundaryExtractor.saveOneMatch(vars, refName, matches);
        } else {
            matchCount = matches.size();
            BoundaryExtractor.saveAllMatches(vars, refName, matches);
        }
        return matchCount;
    }

    private static void saveRandomMatch(JMeterVariables vars, String refName, List<String> matches) {
        String match = matches.get(JMeterUtils.getRandomInt((int)matches.size()));
        if (match != null) {
            vars.put(refName, match);
        }
    }

    private static void saveOneMatch(JMeterVariables vars, String refName, List<String> matches) {
        String match;
        if (matches.size() == 1 && (match = matches.get(0)) != null) {
            vars.put(refName, match);
        }
    }

    private static void saveAllMatches(JMeterVariables vars, String refName, List<String> matches) {
        vars.put(refName + REF_MATCH_NR, Integer.toString(matches.size()));
        for (int i = 0; i < matches.size(); ++i) {
            String match = matches.get(i);
            if (match == null) continue;
            int varNum = i + 1;
            vars.put(refName + '_' + varNum, match);
        }
    }

    private String getInputString(SampleResult result) {
        String inputString = this.chosenInput(result);
        log.debug("Input = '{}'", (Object)inputString);
        return inputString;
    }

    private String chosenInput(SampleResult result) {
        if (this.useUrl()) {
            return result.getUrlAsString();
        }
        if (this.useHeaders()) {
            return result.getResponseHeaders();
        }
        if (this.useRequestHeaders()) {
            return result.getRequestHeaders();
        }
        if (this.useCode()) {
            return result.getResponseCode();
        }
        if (this.useMessage()) {
            return result.getResponseMessage();
        }
        if (this.useUnescapedBody()) {
            return StringEscapeUtils.unescapeHtml4((String)result.getResponseDataAsString());
        }
        if (this.useBodyAsDocument()) {
            return Document.getTextFromDocument((byte[])result.getResponseData());
        }
        return result.getResponseDataAsString();
    }

    @VisibleForTesting
    static List<String> extract(String leftBoundary, String rightBoundary, int matchNumber, Stream<String> previousResults) {
        boolean allItems = matchNumber <= 0;
        return previousResults.flatMap(input -> BoundaryExtractor.extract(leftBoundary, rightBoundary, input).stream()).skip(allItems ? 0L : (long)(matchNumber - 1)).limit(allItems ? Long.MAX_VALUE : 1L).collect(Collectors.toList());
    }

    @VisibleForTesting
    static List<String> extract(String leftBoundary, String rightBoundary, int matchNumber, String inputString) {
        int endIndex;
        int leftBoundaryIndex;
        int rightBoundaryIndex;
        if (StringUtils.isBlank((CharSequence)inputString)) {
            return Collections.emptyList();
        }
        boolean isEmptyLeftBoundary = StringUtils.isEmpty((CharSequence)leftBoundary);
        boolean isEmptyRightBoundary = StringUtils.isEmpty((CharSequence)rightBoundary);
        if (isEmptyLeftBoundary && isEmptyRightBoundary) {
            return Collections.singletonList(inputString);
        }
        if (isEmptyLeftBoundary && (rightBoundaryIndex = inputString.indexOf(rightBoundary)) != -1) {
            return Collections.singletonList(inputString.substring(0, rightBoundaryIndex));
        }
        if (isEmptyRightBoundary && (leftBoundaryIndex = inputString.indexOf(leftBoundary)) != -1) {
            return Collections.singletonList(inputString.substring(leftBoundaryIndex + leftBoundary.length()));
        }
        ArrayList<String> matches = new ArrayList<String>();
        int leftBoundaryLen = leftBoundary.length();
        boolean collectAll = matchNumber <= 0;
        int found = 0;
        int startIndex = 0;
        while ((startIndex = inputString.indexOf(leftBoundary, startIndex)) != -1 && (endIndex = inputString.indexOf(rightBoundary, startIndex + leftBoundaryLen)) >= 0) {
            ++found;
            if (collectAll) {
                matches.add(inputString.substring(startIndex + leftBoundaryLen, endIndex));
            } else if (found == matchNumber) {
                return Collections.singletonList(inputString.substring(startIndex + leftBoundaryLen, endIndex));
            }
            startIndex += leftBoundaryLen;
        }
        return Collections.unmodifiableList(matches);
    }

    public List<String> extractAll(String leftBoundary, String rightBoundary, String textToParse) {
        return BoundaryExtractor.extract(leftBoundary, rightBoundary, textToParse);
    }

    private static List<String> extract(String leftBoundary, String rightBoundary, String textToParse) {
        return BoundaryExtractor.extract(leftBoundary, rightBoundary, -1, textToParse);
    }

    public void setRefName(String refName) {
        this.setProperty(REFNAME, refName);
    }

    public String getRefName() {
        return this.getPropertyAsString(REFNAME);
    }

    public void setMatchNumber(int matchNumber) {
        this.setProperty((JMeterProperty)new IntegerProperty(MATCH_NUMBER, matchNumber));
    }

    public void setMatchNumber(String matchNumber) {
        this.setProperty(MATCH_NUMBER, matchNumber);
    }

    public int getMatchNumber() {
        return this.getPropertyAsInt(MATCH_NUMBER);
    }

    public String getMatchNumberAsString() {
        return this.getPropertyAsString(MATCH_NUMBER);
    }

    public void setLeftBoundary(String leftBoundary) {
        this.setProperty(L_BOUNDARY, leftBoundary);
    }

    public String getLeftBoundary() {
        return this.getPropertyAsString(L_BOUNDARY);
    }

    public void setRightBoundary(String rightBoundary) {
        this.setProperty(R_BOUNDARY, rightBoundary);
    }

    public String getRightBoundary() {
        return this.getPropertyAsString(R_BOUNDARY);
    }

    public void setDefaultValue(String defaultValue) {
        this.setProperty(DEFAULT, defaultValue);
    }

    public void setDefaultEmptyValue(boolean defaultEmptyValue) {
        this.setProperty(DEFAULT_EMPTY_VALUE, defaultEmptyValue);
    }

    public String getDefaultValue() {
        return this.getPropertyAsString(DEFAULT);
    }

    public boolean isEmptyDefaultValue() {
        return this.getPropertyAsBoolean(DEFAULT_EMPTY_VALUE);
    }

    public boolean useHeaders() {
        return USE_HDRS.equalsIgnoreCase(this.getPropertyAsString(MATCH_AGAINST));
    }

    public boolean useRequestHeaders() {
        return USE_REQUEST_HDRS.equalsIgnoreCase(this.getPropertyAsString(MATCH_AGAINST));
    }

    public boolean useBody() {
        String prop = this.getPropertyAsString(MATCH_AGAINST);
        return prop.length() == 0 || USE_BODY.equalsIgnoreCase(prop);
    }

    public boolean useUnescapedBody() {
        String prop = this.getPropertyAsString(MATCH_AGAINST);
        return USE_BODY_UNESCAPED.equalsIgnoreCase(prop);
    }

    public boolean useBodyAsDocument() {
        String prop = this.getPropertyAsString(MATCH_AGAINST);
        return USE_BODY_AS_DOCUMENT.equalsIgnoreCase(prop);
    }

    public boolean useUrl() {
        String prop = this.getPropertyAsString(MATCH_AGAINST);
        return USE_URL.equalsIgnoreCase(prop);
    }

    public boolean useCode() {
        String prop = this.getPropertyAsString(MATCH_AGAINST);
        return USE_CODE.equalsIgnoreCase(prop);
    }

    public boolean useMessage() {
        String prop = this.getPropertyAsString(MATCH_AGAINST);
        return USE_MESSAGE.equalsIgnoreCase(prop);
    }

    public void setUseField(String actionCommand) {
        this.setProperty(MATCH_AGAINST, actionCommand);
    }
}

