/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.jms.sampler.render;

import com.github.benmanes.caffeine.cache.Cache;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.jmeter.protocol.jms.sampler.render.MessageRenderer;
import org.apache.jmeter.protocol.jms.sampler.render.TextMessageRenderer;

public class MapMessageRenderer
implements MessageRenderer<Map<String, Object>> {
    private final TextMessageRenderer delegate;

    public MapMessageRenderer(TextMessageRenderer delegate) {
        this.delegate = delegate;
    }

    @Override
    public Map<String, Object> getValueFromText(String text) {
        String[] lines;
        HashMap<String, Object> m = new HashMap<String, Object>();
        for (String line : lines = text.split("\n")) {
            Object obj;
            String[] parts = line.split(",", 3);
            if (parts.length != 3) {
                throw new IllegalArgumentException("line must have 3 parts: " + line);
            }
            String name = parts[0];
            String type = parts[1];
            if (!type.contains(".")) {
                type = "java.lang." + type;
            }
            String value = parts[2];
            if (type.equals("java.lang.String")) {
                obj = value;
            } else {
                try {
                    Class<?> clazz = Class.forName(type);
                    Method method = clazz.getMethod("valueOf", String.class);
                    obj = method.invoke(clazz, value);
                }
                catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    throw new RuntimeException(String.format("Can't convert %s to object", line), e);
                }
            }
            m.put(name, obj);
        }
        return m;
    }

    @Override
    public Map<String, Object> getValueFromFile(String filename, String encoding, boolean hasVariable, Cache<Object, Object> cache) {
        Object text = this.delegate.getValueFromFile(filename, encoding, hasVariable, (Cache)cache);
        return this.getValueFromText((String)text);
    }
}

