/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.Context;
import org.jooq.Field;
import org.jooq.Function2;
import org.jooq.JSON;
import org.jooq.impl.AbstractCondition;
import org.jooq.impl.DSL;
import org.jooq.impl.Names;
import org.jooq.impl.QOM;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.Tools;
import org.jooq.tools.StringUtils;

final class JSONKeyExists
extends AbstractCondition
implements QOM.JSONKeyExists {
    final Field<JSON> json;
    final Field<String> key;

    JSONKeyExists(Field<JSON> json, Field<String> key) {
        this.json = Tools.nullSafeNotNull(json, SQLDataType.JSON);
        this.key = Tools.nullSafeNotNull(key, SQLDataType.VARCHAR);
    }

    @Override
    final boolean parenthesised(Context<?> ctx) {
        switch (ctx.family()) {
            case CLICKHOUSE: 
            case DUCKDB: 
            case MARIADB: 
            case MYSQL: 
            case SQLITE: 
            case TRINO: {
                return false;
            }
            case POSTGRES: 
            case YUGABYTEDB: {
                return false;
            }
        }
        return true;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case CLICKHOUSE: 
            case DUCKDB: 
            case MARIADB: 
            case MYSQL: 
            case SQLITE: 
            case TRINO: {
                ctx.visit(DSL.jsonGetAttribute(this.json, this.key).isNotNull());
                break;
            }
            case POSTGRES: 
            case YUGABYTEDB: {
                ctx.sql('(').visit(this.json.cast(SQLDataType.JSONB)).sql(" ?? ").visit(this.key).sql(')');
                break;
            }
            default: {
                ctx.visit(DSL.function(Names.N_JSON_KEY_EXISTS, SQLDataType.BOOLEAN, this.json, this.key));
            }
        }
    }

    @Override
    public final Field<JSON> $arg1() {
        return this.json;
    }

    @Override
    public final Field<String> $arg2() {
        return this.key;
    }

    @Override
    public final QOM.JSONKeyExists $arg1(Field<JSON> newValue) {
        return this.$constructor().apply((Field<JSON>)newValue, (Field<String>)this.$arg2());
    }

    @Override
    public final QOM.JSONKeyExists $arg2(Field<String> newValue) {
        return this.$constructor().apply((Field<JSON>)this.$arg1(), (Field<String>)newValue);
    }

    @Override
    public final Function2<? super Field<JSON>, ? super Field<String>, ? extends QOM.JSONKeyExists> $constructor() {
        return (a1, a2) -> new JSONKeyExists((Field<JSON>)a1, (Field<String>)a2);
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof QOM.JSONKeyExists) {
            QOM.JSONKeyExists o = (QOM.JSONKeyExists)that;
            return StringUtils.equals(this.$json(), o.$json()) && StringUtils.equals(this.$key(), o.$key());
        }
        return super.equals(that);
    }
}

