/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.adapter.mailbox;

import com.github.fge.lambdas.Throwing;
import jakarta.inject.Inject;
import java.util.Optional;
import org.apache.james.core.Username;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.SubscriptionManager;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxMetaData;
import org.apache.james.mailbox.model.search.MailboxQuery;
import org.apache.james.mailbox.store.StoreMailboxManager;
import org.apache.james.user.api.DeleteUserDataTaskStep;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MailboxUserDeletionTaskStep
implements DeleteUserDataTaskStep {
    private final StoreMailboxManager mailboxManager;
    private final SubscriptionManager subscriptionManager;

    @Inject
    public MailboxUserDeletionTaskStep(StoreMailboxManager mailboxManager, SubscriptionManager subscriptionManager) {
        this.mailboxManager = mailboxManager;
        this.subscriptionManager = subscriptionManager;
    }

    public DeleteUserDataTaskStep.StepName name() {
        return new DeleteUserDataTaskStep.StepName("MailboxUserDeletionTaskStep");
    }

    public int priority() {
        return 5;
    }

    public Publisher<Void> deleteUserData(Username username) {
        MailboxSession mailboxSession = this.mailboxManager.createSystemSession(username);
        return this.getAllMailboxesOfUser(mailboxSession).concatMap(mailbox -> this.deleteMailbox(mailboxSession, (MailboxMetaData)mailbox).then(this.deleteSubscription(mailboxSession, (MailboxMetaData)mailbox))).then(this.getSharedMailboxesOfUser(mailboxSession).flatMap(sharedMailbox -> this.revokeACLs(username, (MailboxMetaData)sharedMailbox).then(this.deleteSubscription(mailboxSession, (MailboxMetaData)sharedMailbox))).then()).doFinally(any -> this.mailboxManager.endProcessingRequest(mailboxSession));
    }

    private Flux<MailboxMetaData> getAllMailboxesOfUser(MailboxSession mailboxSession) {
        MailboxQuery queryMailboxesOfUser = MailboxQuery.builder().privateNamespace().user(mailboxSession.getUser()).build();
        return this.mailboxManager.search(queryMailboxesOfUser, MailboxManager.MailboxSearchFetchType.Minimal, mailboxSession);
    }

    private Flux<MailboxMetaData> getSharedMailboxesOfUser(MailboxSession mailboxSession) {
        return this.mailboxManager.search(MailboxQuery.builder().matchesAllMailboxNames().build(), mailboxSession).filter(mailbox -> !mailbox.getPath().getUser().equals((Object)mailboxSession.getUser()));
    }

    private Mono<Mailbox> deleteMailbox(MailboxSession mailboxSession, MailboxMetaData mailbox) {
        return this.mailboxManager.deleteMailboxReactive(mailbox.getId(), mailboxSession);
    }

    private Mono<Void> deleteSubscription(MailboxSession mailboxSession, MailboxMetaData mailbox) {
        return Mono.from((Publisher)this.subscriptionManager.unsubscribeReactive(mailbox.getPath(), mailboxSession));
    }

    private Mono<Void> revokeACLs(Username username, MailboxMetaData mailbox) {
        MailboxSession ownerSession = this.mailboxManager.createSystemSession(mailbox.getPath().getUser());
        MailboxACL.Rfc4314Rights rights = Optional.ofNullable((MailboxACL.Rfc4314Rights)mailbox.getMailbox().getACL().getEntries().get(MailboxACL.EntryKey.createUserEntryKey((Username)username))).orElse(MailboxACL.NO_RIGHTS);
        return Mono.fromRunnable((Runnable)Throwing.runnable(() -> this.mailboxManager.applyRightsCommand(mailbox.getId(), MailboxACL.command().rights(rights).forUser(username).asRemoval(), ownerSession))).subscribeOn(ReactorUtils.BLOCKING_CALL_WRAPPER).then().doFinally(any -> this.mailboxManager.endProcessingRequest(ownerSession));
    }
}

