/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.client;

import io.r2dbc.postgresql.message.backend.ReadyForQuery;
import io.r2dbc.postgresql.util.Assert;

public enum TransactionStatus {
    FAILED(ReadyForQuery.TransactionStatus.ERROR),
    IDLE(ReadyForQuery.TransactionStatus.IDLE),
    OPEN(ReadyForQuery.TransactionStatus.TRANSACTION);

    private static final TransactionStatus[] CACHE;
    private final ReadyForQuery.TransactionStatus discriminator;

    private TransactionStatus(ReadyForQuery.TransactionStatus discriminator) {
        this.discriminator = Assert.requireNonNull(discriminator, "discriminator must not be null");
    }

    static TransactionStatus valueOf(ReadyForQuery.TransactionStatus t) {
        Assert.requireNonNull(t, "t must not be null");
        for (TransactionStatus transactionStatus : CACHE) {
            if (transactionStatus.discriminator != t) continue;
            return transactionStatus;
        }
        throw new IllegalArgumentException(String.format("%s is not a valid transaction status", new Object[]{t}));
    }

    static {
        CACHE = TransactionStatus.values();
    }
}

