/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.com.send.parameters;

import java.io.IOException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import org.mariadb.jdbc.internal.ColumnType;
import org.mariadb.jdbc.internal.com.send.parameters.ParameterHolder;
import org.mariadb.jdbc.internal.io.output.PacketOutputStream;

public class TimestampParameter
implements Cloneable,
ParameterHolder {
    private final Timestamp ts;
    private final TimeZone timeZone;
    private final boolean fractionalSeconds;

    public TimestampParameter(Timestamp ts, TimeZone timeZone, boolean fractionalSeconds) {
        this.ts = ts;
        this.timeZone = timeZone;
        this.fractionalSeconds = fractionalSeconds;
    }

    @Override
    public void writeTo(PacketOutputStream pos) throws IOException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (this.timeZone != null) {
            sdf.setTimeZone(this.timeZone);
        }
        pos.write(39);
        pos.write(sdf.format(this.ts).getBytes());
        int microseconds = this.ts.getNanos() / 1000;
        if (microseconds > 0 && this.fractionalSeconds) {
            pos.write(46);
            int factor = 100000;
            while (microseconds > 0) {
                int dig = microseconds / factor;
                pos.write(48 + dig);
                microseconds -= dig * factor;
                factor /= 10;
            }
        }
        pos.write(39);
    }

    @Override
    public int getApproximateTextProtocolLength() {
        return 27;
    }

    @Override
    public void writeBinary(PacketOutputStream pos) throws IOException {
        Calendar calendar = this.timeZone == null ? Calendar.getInstance() : Calendar.getInstance(this.timeZone);
        calendar.setTimeInMillis(this.ts.getTime());
        pos.write((byte)(this.fractionalSeconds ? 11 : 7));
        pos.writeShort((short)calendar.get(1));
        pos.write((byte)(calendar.get(2) + 1 & 0xFF));
        pos.write((byte)(calendar.get(5) & 0xFF));
        pos.write((byte)calendar.get(11));
        pos.write((byte)calendar.get(12));
        pos.write((byte)calendar.get(13));
        if (this.fractionalSeconds) {
            pos.writeInt(this.ts.getNanos() / 1000);
        }
    }

    @Override
    public ColumnType getColumnType() {
        return ColumnType.DATETIME;
    }

    @Override
    public String toString() {
        return "'" + this.ts.toString() + "'";
    }

    @Override
    public boolean isNullData() {
        return false;
    }

    @Override
    public boolean canBeLongData() {
        return false;
    }
}

