/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.codec;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.james.mime4j.codec.Base64InputStream;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.codec.QuotedPrintableInputStream;
import org.apache.james.mime4j.io.InputStreams;
import org.apache.james.mime4j.util.ByteArrayBuffer;
import org.apache.james.mime4j.util.CharsetUtil;

public class DecoderUtil {
    private static final Pattern PATTERN_ENCODED_WORD = Pattern.compile("=\\?(.+?)\\?(\\w)\\?(.*?)\\?=", 32);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] decodeQuotedPrintable(String s2, DecodeMonitor monitor) {
        byte[] byArray;
        QuotedPrintableInputStream is = new QuotedPrintableInputStream(InputStreams.createAscii(s2), monitor);
        try {
            int b;
            ByteArrayBuffer buf = new ByteArrayBuffer(s2.length());
            while ((b = is.read()) != -1) {
                buf.append(b);
            }
            byArray = buf.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                is.close();
                throw throwable;
            }
            catch (IOException ex) {
                throw new Error(ex);
            }
        }
        is.close();
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] decodeBase64(String s2, DecodeMonitor monitor) {
        byte[] byArray;
        Base64InputStream is = new Base64InputStream(InputStreams.createAscii(s2), monitor);
        try {
            int b;
            ByteArrayBuffer buf = new ByteArrayBuffer(s2.length());
            while ((b = is.read()) != -1) {
                buf.append(b);
            }
            byArray = buf.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                is.close();
                throw throwable;
            }
            catch (IOException ex) {
                throw new Error(ex);
            }
        }
        is.close();
        return byArray;
    }

    static String decodeB(String encodedText, String charset, DecodeMonitor monitor) throws UnsupportedEncodingException {
        byte[] decodedBytes = DecoderUtil.decodeBase64(encodedText, monitor);
        return new String(decodedBytes, charset);
    }

    static String decodeQ(String encodedText, String charset, DecodeMonitor monitor) throws UnsupportedEncodingException {
        encodedText = DecoderUtil.replaceUnderscores(encodedText);
        byte[] decodedBytes = DecoderUtil.decodeQuotedPrintable(encodedText, monitor);
        return new String(decodedBytes, charset);
    }

    static String decodeEncodedWords(String body) {
        return DecoderUtil.decodeEncodedWords(body, DecodeMonitor.SILENT);
    }

    public static String decodeEncodedWords(String body, DecodeMonitor monitor) throws IllegalArgumentException {
        return DecoderUtil.decodeEncodedWords(body, monitor, null);
    }

    public static String decodeEncodedWords(String body, Charset fallback) throws IllegalArgumentException {
        return DecoderUtil.decodeEncodedWords(body, null, fallback);
    }

    public static String decodeEncodedWords(String body, DecodeMonitor monitor, Charset fallback) throws IllegalArgumentException {
        int tailIndex = 0;
        boolean lastMatchValid = false;
        StringBuilder sb = new StringBuilder();
        Matcher matcher = PATTERN_ENCODED_WORD.matcher(body);
        while (matcher.find()) {
            String separator = body.substring(tailIndex, matcher.start());
            String mimeCharset = matcher.group(1);
            String encoding = matcher.group(2);
            String encodedText = matcher.group(3);
            if (encodedText.isEmpty()) {
                return "";
            }
            String decoded = DecoderUtil.tryDecodeEncodedWord(mimeCharset, encoding, encodedText, monitor, fallback);
            if (decoded == null) {
                sb.append(separator);
                sb.append(matcher.group(0));
            } else {
                if (!lastMatchValid || !CharsetUtil.isWhitespace(separator)) {
                    sb.append(separator);
                }
                sb.append(decoded);
            }
            tailIndex = matcher.end();
            lastMatchValid = decoded != null;
        }
        if (tailIndex == 0) {
            return body;
        }
        sb.append(body.substring(tailIndex));
        return sb.toString();
    }

    private static String tryDecodeEncodedWord(String mimeCharset, String encoding, String encodedText, DecodeMonitor monitor, Charset fallback) {
        Charset charset = CharsetUtil.lookup(mimeCharset);
        if (charset == null) {
            if (fallback == null) {
                DecoderUtil.monitor(monitor, mimeCharset, encoding, encodedText, "leaving word encoded", "Mime charser '", mimeCharset, "' doesn't have a corresponding Java charset");
                return null;
            }
            charset = fallback;
        }
        if (encodedText.length() == 0) {
            DecoderUtil.monitor(monitor, mimeCharset, encoding, encodedText, "leaving word encoded", "Missing encoded text in encoded word");
            return null;
        }
        try {
            if (encoding.equalsIgnoreCase("Q")) {
                return DecoderUtil.decodeQ(encodedText, charset.name(), monitor);
            }
            if (encoding.equalsIgnoreCase("B")) {
                return DecoderUtil.decodeB(encodedText, charset.name(), monitor);
            }
            DecoderUtil.monitor(monitor, mimeCharset, encoding, encodedText, "leaving word encoded", "Warning: Unknown encoding in encoded word");
            return null;
        }
        catch (UnsupportedEncodingException e) {
            DecoderUtil.monitor(monitor, mimeCharset, encoding, encodedText, "leaving word encoded", "Unsupported encoding (", e.getMessage(), ") in encoded word");
            return null;
        }
        catch (RuntimeException e) {
            DecoderUtil.monitor(monitor, mimeCharset, encoding, encodedText, "leaving word encoded", "Could not decode (", e.getMessage(), ") encoded word");
            return null;
        }
    }

    private static void monitor(DecodeMonitor monitor, String mimeCharset, String encoding, String encodedText, String dropDesc, String ... strings) throws IllegalArgumentException {
        if (monitor.isListening()) {
            String encodedWord = DecoderUtil.recombine(mimeCharset, encoding, encodedText);
            StringBuilder text = new StringBuilder();
            for (String str : strings) {
                text.append(str);
            }
            text.append(" (");
            text.append(encodedWord);
            text.append(")");
            String exceptionDesc = text.toString();
            if (monitor.warn(exceptionDesc, dropDesc)) {
                throw new IllegalArgumentException(text.toString());
            }
        }
    }

    private static String recombine(String mimeCharset, String encoding, String encodedText) {
        return "=?" + mimeCharset + "?" + encoding + "?" + encodedText + "?=";
    }

    private static String replaceUnderscores(String str) {
        StringBuilder sb = new StringBuilder(128);
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '_') {
                sb.append("=20");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

