/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.persist;

import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;

final class TypeInfo {
    private final boolean isArray;
    private final boolean isEnum;
    private final boolean isList;
    private final boolean isSet;
    private final boolean isSupported;
    @Nullable
    private final Class<?> baseClass;
    @Nullable
    private final Class<?> componentType;
    @NotNull
    private final Type type;

    TypeInfo(@NotNull Type type) {
        this.type = type;
        if (type instanceof Class) {
            this.isSupported = true;
            this.baseClass = (Class)type;
            this.isArray = this.baseClass.isArray();
            this.isEnum = this.baseClass.isEnum();
            if (this.isArray) {
                this.componentType = this.baseClass.getComponentType();
                this.isList = false;
                this.isSet = false;
            } else if (List.class.isAssignableFrom(this.baseClass)) {
                this.componentType = Object.class;
                this.isList = true;
                this.isSet = false;
            } else if (Set.class.isAssignableFrom(this.baseClass)) {
                this.componentType = Object.class;
                this.isList = false;
                this.isSet = true;
            } else {
                this.componentType = null;
                this.isList = false;
                this.isSet = false;
            }
        } else if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            Type rawType = pt.getRawType();
            Type[] typeParams = pt.getActualTypeArguments();
            if (rawType instanceof Class && typeParams.length == 1 && typeParams[0] instanceof Class) {
                this.baseClass = (Class)rawType;
                this.componentType = (Class)typeParams[0];
                if (List.class.isAssignableFrom(this.baseClass)) {
                    this.isSupported = true;
                    this.isArray = false;
                    this.isEnum = false;
                    this.isList = true;
                    this.isSet = false;
                } else if (Set.class.isAssignableFrom(this.baseClass)) {
                    this.isSupported = true;
                    this.isArray = false;
                    this.isEnum = false;
                    this.isList = false;
                    this.isSet = true;
                } else {
                    this.isSupported = false;
                    this.isArray = false;
                    this.isEnum = false;
                    this.isList = false;
                    this.isSet = false;
                }
            } else {
                this.isSupported = false;
                this.isArray = false;
                this.isEnum = false;
                this.isList = false;
                this.isSet = false;
                this.baseClass = null;
                this.componentType = null;
            }
        } else {
            this.isSupported = false;
            this.isArray = false;
            this.isEnum = false;
            this.isList = false;
            this.isSet = false;
            this.baseClass = null;
            this.componentType = null;
        }
    }

    @NotNull
    public Type getType() {
        return this.type;
    }

    public boolean isSupported() {
        return this.isSupported;
    }

    @Nullable
    public Class<?> getBaseClass() {
        return this.baseClass;
    }

    @Nullable
    public Class<?> getComponentType() {
        return this.componentType;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public boolean isEnum() {
        return this.isEnum;
    }

    public boolean isList() {
        return this.isList;
    }

    public boolean isSet() {
        return this.isSet;
    }

    public boolean isMultiValued() {
        return this.isArray || this.isList || this.isSet;
    }
}

