/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.github.fge.lambdas.Throwing;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.james.core.MailAddress;
import org.apache.james.mime4j.util.MimeUtil;
import org.apache.james.util.StreamUtils;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeName;
import org.apache.mailet.AttributeValue;
import org.apache.mailet.Mail;
import org.apache.mailet.Mailet;
import org.apache.mailet.MailetException;
import org.apache.mailet.base.GenericMailet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContactExtractor
extends GenericMailet
implements Mailet {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContactExtractor.class);
    @VisibleForTesting
    ObjectMapper objectMapper;
    private AttributeName extractAttributeTo;

    public void init() throws MessagingException {
        this.extractAttributeTo = this.getInitParameterAsOptional("attribute").map(AttributeName::of).orElseThrow(() -> new MailetException("No value for attribute parameter was provided."));
        this.objectMapper = new ObjectMapper().registerModule((Module)new Jdk8Module());
    }

    public String getMailetInfo() {
        return "ContactExtractor Mailet";
    }

    public void service(Mail mail) throws MessagingException {
        try {
            Optional<String> payload = this.extractContacts(mail);
            LOGGER.debug("payload : {}", payload);
            payload.map(AttributeValue::of).ifPresent(x -> mail.setAttribute(new Attribute(this.extractAttributeTo, x)));
        }
        catch (Exception e) {
            LOGGER.error("Error while extracting contacts", (Throwable)e);
        }
    }

    @VisibleForTesting
    Optional<String> extractContacts(Mail mail) throws MessagingException {
        ImmutableList<String> allRecipients = this.getAllRecipients(mail.getMessage());
        if (this.hasRecipient(allRecipients)) {
            return mail.getMaybeSender().asOptional().map(MailAddress::asString).map(sender -> new ExtractedContacts((String)sender, allRecipients)).map(Throwing.function(extractedContacts -> this.objectMapper.writeValueAsString(extractedContacts)));
        }
        return Optional.empty();
    }

    private boolean hasRecipient(ImmutableList<String> allRecipients) {
        return !allRecipients.isEmpty();
    }

    private ImmutableList<String> getAllRecipients(MimeMessage mimeMessage) throws MessagingException {
        return (ImmutableList)StreamUtils.flatten((Stream[])new Stream[]{this.getRecipients(mimeMessage, Message.RecipientType.TO), this.getRecipients(mimeMessage, Message.RecipientType.CC), this.getRecipients(mimeMessage, Message.RecipientType.BCC)}).collect(ImmutableList.toImmutableList());
    }

    private Stream<String> getRecipients(MimeMessage mimeMessage, Message.RecipientType recipientType) throws MessagingException {
        boolean notStrict = false;
        Function parseRecipient = Throwing.function(header -> InternetAddress.parseHeader((String)header, (boolean)notStrict)).sneakyThrow();
        return StreamUtils.ofOptional(Optional.ofNullable(mimeMessage.getHeader(recipientType.toString(), ",")).map(parseRecipient)).map(Address::toString).map(MimeUtil::unscrambleHeaderValue);
    }

    public static class ExtractedContacts {
        private final String userEmail;
        private final ImmutableList<String> emails;

        public ExtractedContacts(String userEmail, ImmutableList<String> emails) {
            this.emails = emails;
            this.userEmail = userEmail;
        }

        public ImmutableList<String> getEmails() {
            return this.emails;
        }

        public String getUserEmail() {
            return this.userEmail;
        }
    }

    public static interface Configuration {
        public static final String ATTRIBUTE = "attribute";
    }
}

