/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail.eventsourcing.acl;

import com.github.fge.lambdas.Throwing;
import java.util.List;
import java.util.function.Function;
import org.apache.james.eventsourcing.AggregateId;
import org.apache.james.eventsourcing.Command;
import org.apache.james.eventsourcing.Event;
import org.apache.james.eventsourcing.eventstore.EventStore;
import org.apache.james.mailbox.cassandra.mail.eventsourcing.acl.MailboxACLAggregate;
import org.apache.james.mailbox.cassandra.mail.eventsourcing.acl.MailboxAggregateId;
import org.apache.james.mailbox.model.MailboxACL;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class UpdateACLCommand
implements Command {
    private final MailboxAggregateId id;
    private final MailboxACL.ACLCommand aclCommand;

    public UpdateACLCommand(MailboxAggregateId id, MailboxACL.ACLCommand aclCommand) {
        this.id = id;
        this.aclCommand = aclCommand;
    }

    public MailboxAggregateId getId() {
        return this.id;
    }

    public MailboxACL.ACLCommand getAclCommand() {
        return this.aclCommand;
    }

    public static class CommandHandler
    implements org.apache.james.eventsourcing.CommandHandler<UpdateACLCommand> {
        private final EventStore eventStore;

        public CommandHandler(EventStore eventStore) {
            this.eventStore = eventStore;
        }

        public Class<UpdateACLCommand> handledClass() {
            return UpdateACLCommand.class;
        }

        public Publisher<List<? extends Event>> handle(UpdateACLCommand command) {
            return Mono.from((Publisher)this.eventStore.getEventsOfAggregate((AggregateId)command.getId())).map(history -> MailboxACLAggregate.load(command.getId(), history)).map((Function)Throwing.function(aggregate -> aggregate.update(command)));
        }
    }
}

