/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.offheap.structs;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.nustaq.offheap.bytez.BasicBytez;
import org.nustaq.offheap.bytez.ByteSource;
import org.nustaq.offheap.bytez.Bytez;
import org.nustaq.offheap.bytez.malloc.MallocBytez;
import org.nustaq.offheap.bytez.onheap.HeapBytez;
import org.nustaq.offheap.structs.FSTStructChange;
import org.nustaq.offheap.structs.unsafeimpl.FSTStructFactory;
import org.nustaq.serialization.util.FSTUtil;

public class FSTStruct
implements Serializable {
    public transient long ___offset;
    public transient Bytez ___bytes;
    public transient FSTStructFactory ___fac;
    public transient int ___elementSize;
    public transient FSTStructChange tracker;
    static Field address = null;
    static Field capacity = null;
    static ThreadLocal<ByteBuffer> tmpBuf = new ThreadLocal<ByteBuffer>(){

        @Override
        protected ByteBuffer initialValue() {
            ArrayList<Field> fields = new ArrayList<Field>();
            ByteBuffer tmpSend = ByteBuffer.allocateDirect(0);
            FSTUtil.getAllFields(fields, tmpSend.getClass());
            if (address == null || capacity == null) {
                for (int i = 0; i < fields.size(); ++i) {
                    Field field2 = (Field)fields.get(i);
                    if (field2.getName().equals("address")) {
                        address = field2;
                        continue;
                    }
                    if (!field2.getName().equals("capacity")) continue;
                    capacity = field2;
                }
                address.setAccessible(true);
                capacity.setAccessible(true);
            }
            return tmpSend;
        }
    };

    protected void setAbsoluteOffset(long off) {
        this.___offset = off;
    }

    protected long getAbsoluteOffset() {
        return this.___offset;
    }

    public long getOffset() {
        return this.___offset;
    }

    public long getIndexInBase() {
        return this.___offset;
    }

    public int getByteSize() {
        if (!this.isOffHeap()) {
            return 0;
        }
        return this.___bytes.getInt(this.___offset);
    }

    public Class getPointedClass() {
        if (!this.isOffHeap()) {
            throw new RuntimeException("cannot call on heap");
        }
        Class clazz = this.___fac.getClazz(this.getClzId());
        if (clazz == null) {
            return FSTStruct.class;
        }
        return clazz;
    }

    public int getClzId() {
        if (!this.isOffHeap()) {
            throw new RuntimeException("cannot call on heap");
        }
        return this.___bytes.getInt(this.___offset + 4L);
    }

    public boolean pointsToNull() {
        return this.getClzId() <= 0;
    }

    protected void addOffset(long off) {
        this.___offset += off;
    }

    protected void setBase(Bytez base) {
        this.___bytes = base;
    }

    public Bytez getBase() {
        return this.___bytes;
    }

    public FSTStructFactory getFac() {
        return this.___fac;
    }

    public void baseOn(byte[] base, long offset, FSTStructFactory fac) {
        this.___bytes = new HeapBytez(base);
        this.___offset = offset;
        this.___fac = fac;
    }

    public void baseOn(Bytez base, long offset, FSTStructFactory fac) {
        this.___bytes = base;
        this.___offset = offset;
        this.___fac = fac;
    }

    public void baseOn(byte[] base, int index) {
        this.___bytes = new HeapBytez(base);
        this.___offset = index;
        if (this.___fac == null) {
            this.___fac = FSTStructFactory.getInstance();
        }
    }

    public void baseOn(Bytez base, int index) {
        this.___bytes = base;
        this.___offset = index;
        if (this.___fac == null) {
            this.___fac = FSTStructFactory.getInstance();
        }
    }

    public boolean isIdenticTo(FSTStruct other) {
        return other.getBase().equals(this.___bytes) && other.getAbsoluteOffset() == this.___offset;
    }

    public int hashCode() {
        if (!this.isOffHeap()) {
            return this.onHeapHashcode();
        }
        return this.___bytes.getInt(this.___offset) ^ this.___bytes.getInt(this.___offset + (long)this.getByteSize() - 4L);
    }

    public int onHeapHashcode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof FSTStruct) {
            FSTStruct other = (FSTStruct)obj;
            int len = this.getByteSize();
            if (other.getByteSize() == len) {
                long ix = this.getOffset();
                long ox = other.getOffset();
                for (int i = 0; i < len; ++i) {
                    if (this.___bytes.get((long)i + ix) == other.___bytes.get((long)i + ox)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return super.equals(obj);
    }

    public boolean isOffHeap() {
        return this.___fac != null;
    }

    public int getElementInArraySize() {
        return this.___elementSize;
    }

    public boolean isStructArrayPointer() {
        return this.___elementSize > 0;
    }

    public boolean isNull() {
        return this.getClzId() <= 0;
    }

    public <T extends FSTStruct> T detach() {
        if (this.isOffHeap()) {
            this.___fac.detach(this);
        }
        return (T)this;
    }

    public <T extends FSTStruct> T detachTo(T pointer) {
        if (pointer == null) {
            return this.detach();
        }
        if (this.isOffHeap()) {
            pointer.___fac = this.___fac;
            pointer.___bytes = this.___bytes;
            pointer.___elementSize = this.___elementSize;
            pointer.___offset = this.___offset;
            return pointer;
        }
        return (T)this;
    }

    public final void next() {
        if (this.___elementSize > 0) {
            this.___offset += (long)this.___elementSize;
        } else {
            throw new RuntimeException("not pointing to a struct array");
        }
    }

    public final void next(int offset) {
        this.___offset += (long)offset;
    }

    public final void previous() {
        if (this.___elementSize > 0) {
            this.___offset -= (long)this.___elementSize;
        } else {
            throw new RuntimeException("not pointing to a struct array");
        }
    }

    public <T extends FSTStruct> T cast(Class<T> to) {
        int clzId = this.___fac.getClzId(to);
        if (this.getClass().getSuperclass() == to) {
            return (T)this;
        }
        FSTStruct res = this.___fac.createStructPointer(this.___bytes, (int)this.___offset, clzId);
        res.___elementSize = this.___elementSize;
        return (T)res;
    }

    public <T extends FSTStruct> T cast() {
        int clzId = this.getClzId();
        if (this.___fac.getClazz(clzId) == this.getClass().getSuperclass()) {
            return (T)this;
        }
        FSTStruct res = this.___fac.getStructPointerByOffset(this.___bytes, this.___offset);
        res.___elementSize = this.___elementSize;
        return (T)res;
    }

    public byte getByte() {
        return this.___bytes.get(this.___offset);
    }

    public void setByte(byte i) {
        this.___bytes.put(this.___offset, i);
    }

    public char getChar() {
        return this.___bytes.getChar(this.___offset);
    }

    public short getShort() {
        return this.___bytes.getShort(this.___offset);
    }

    public void setShort(short i) {
        this.___bytes.putShort(this.___offset, i);
    }

    public int getInt() {
        return this.___bytes.getInt(this.___offset);
    }

    public void setInt(int i) {
        this.___bytes.putInt(this.___offset, i);
    }

    public long getLong() {
        return this.___bytes.getLong(this.___offset);
    }

    public void setLong(long i) {
        this.___bytes.putLong(this.___offset, i);
    }

    public float getFloat() {
        return this.___bytes.getFloat(this.___offset);
    }

    public double getDouble() {
        return this.___bytes.getDouble(this.___offset);
    }

    public void getBytes(byte[] target, int startIndexInTarget, int len) {
        if (!this.isOffHeap()) {
            throw new RuntimeException("must be offheap to call this");
        }
        this.___bytes.getArr(this.___offset, target, startIndexInTarget, len);
    }

    public void getBytes(Bytez target, int startIndexInTarget) {
        if (!this.isOffHeap()) {
            throw new RuntimeException("must be offheap to call this");
        }
        if (target.length() < (long)(startIndexInTarget + this.getByteSize())) {
            throw new RuntimeException("ArrayIndexOutofBounds byte len:" + target.length() + " start+size:" + (startIndexInTarget + this.getByteSize()));
        }
        this.___bytes.copyTo(target, startIndexInTarget, this.___offset, this.getByteSize());
    }

    public void setBytes(byte[] source, int sourceIndex, int len) {
        if (!this.isOffHeap()) {
            throw new RuntimeException("must be offheap to call this");
        }
        this.___bytes.set(this.___offset, source, sourceIndex, len);
    }

    public void setBytes(ByteSource source, long sourceIndex, int len) {
        if (!this.isOffHeap()) {
            throw new RuntimeException("must be offheap to call this");
        }
        if (source instanceof BasicBytez) {
            ((BasicBytez)source).copyTo(this.___bytes, this.___offset, sourceIndex, len);
        } else {
            for (long i = 0L; i < (long)len; ++i) {
                this.___bytes.put(this.___offset + i, source.get(i + sourceIndex));
            }
        }
    }

    public void setBytes(Bytez source, long sourceIndex, int len) {
        if (!this.isOffHeap()) {
            throw new RuntimeException("must be offheap to call this");
        }
        source.copyTo(this.___bytes, this.___offset, sourceIndex, len);
    }

    public FSTStruct createCopy() {
        if (!this.isOffHeap()) {
            throw new RuntimeException("must be offheap to call this");
        }
        byte[] b = new byte[this.getByteSize()];
        HeapBytez res = new HeapBytez(b);
        this.getBytes(res, 0);
        return this.___fac.createStructWrapper(res, 0L);
    }

    public FSTStruct startChangeTracking() {
        this.tracker = new FSTStructChange();
        return this;
    }

    public FSTStructChange finishChangeTracking() {
        this.tracker.snapshotChanges((int)this.getOffset(), this.getBase());
        FSTStructChange res = this.tracker;
        this.tracker = null;
        return res;
    }

    public boolean isChangeTracking() {
        return this.tracker != null;
    }

    public FSTStruct toOffHeap() {
        if (this.isOffHeap()) {
            return this;
        }
        return FSTStructFactory.getInstance().toStruct(this);
    }

    public Object getFieldValues() {
        throw new RuntimeException("only supported for structs");
    }

    public ByteBuffer asByteBufferTemporary() {
        if (this.getBase() instanceof MallocBytez) {
            MallocBytez base = (MallocBytez)this.getBase();
            ByteBuffer bb = tmpBuf.get();
            try {
                address.setLong(bb, base.getBaseAdress() + this.getOffset());
                capacity.setInt(bb, this.getByteSize());
            }
            catch (IllegalAccessException e) {
                FSTUtil.rethrow(e);
            }
            bb.limit((int)(this.getOffset() + (long)this.getByteSize()));
            bb.position((int)this.getOffset());
            return tmpBuf.get();
        }
        return ByteBuffer.wrap(this.getBase().asByteArray(), (int)this.getOffset(), this.getByteSize());
    }
}

