/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.column.unary.scalar;

import java.time.ZoneId;
import java.time.temporal.ChronoField;
import java.util.function.Function;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Extract;
import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.unary.UnaryColumnTransformer;
import org.apache.iotdb.db.utils.DateTimeUtils;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.read.common.type.Type;

public class ExtractTransformer
extends UnaryColumnTransformer {
    private final Function<Long, Long> evaluateFunction;

    public ExtractTransformer(Type type, ColumnTransformer child, Extract.Field field, ZoneId zoneId) {
        super(type, child);
        this.evaluateFunction = ExtractTransformer.constructEvaluateFunction(field, zoneId);
    }

    public static Function<Long, Long> constructEvaluateFunction(Extract.Field field, ZoneId zoneId) {
        switch (field) {
            case YEAR: {
                return timestamp -> DateTimeUtils.convertToZonedDateTime(timestamp, zoneId).getYear();
            }
            case QUARTER: {
                return timestamp -> ((long)DateTimeUtils.convertToZonedDateTime(timestamp, zoneId).getMonthValue() + 2L) / 3L;
            }
            case MONTH: {
                return timestamp -> DateTimeUtils.convertToZonedDateTime(timestamp, zoneId).getMonthValue();
            }
            case WEEK: {
                return timestamp -> DateTimeUtils.convertToZonedDateTime(timestamp, zoneId).getLong(ChronoField.ALIGNED_WEEK_OF_YEAR);
            }
            case DAY: 
            case DAY_OF_MONTH: {
                return timestamp -> DateTimeUtils.convertToZonedDateTime(timestamp, zoneId).getDayOfMonth();
            }
            case DAY_OF_WEEK: 
            case DOW: {
                return timestamp -> DateTimeUtils.convertToZonedDateTime(timestamp, zoneId).getDayOfWeek().getValue();
            }
            case DAY_OF_YEAR: 
            case DOY: {
                return timestamp -> DateTimeUtils.convertToZonedDateTime(timestamp, zoneId).getDayOfYear();
            }
            case HOUR: {
                return timestamp -> DateTimeUtils.convertToZonedDateTime(timestamp, zoneId).getHour();
            }
            case MINUTE: {
                return timestamp -> DateTimeUtils.convertToZonedDateTime(timestamp, zoneId).getMinute();
            }
            case SECOND: {
                return timestamp -> DateTimeUtils.convertToZonedDateTime(timestamp, zoneId).getSecond();
            }
            case MS: {
                return DateTimeUtils.EXTRACT_TIMESTAMP_MS_PART;
            }
            case US: {
                return DateTimeUtils.EXTRACT_TIMESTAMP_US_PART;
            }
            case NS: {
                return DateTimeUtils.EXTRACT_TIMESTAMP_NS_PART;
            }
        }
        throw new UnsupportedOperationException("Unexpected extract field: " + (Object)((Object)field));
    }

    @Override
    protected void doTransform(Column column, ColumnBuilder columnBuilder) {
        int n = column.getPositionCount();
        for (int i = 0; i < n; ++i) {
            if (!column.isNull(i)) {
                columnBuilder.writeLong(this.evaluateFunction.apply(column.getLong(i)).longValue());
                continue;
            }
            columnBuilder.appendNull();
        }
    }

    @Override
    protected void doTransform(Column column, ColumnBuilder columnBuilder, boolean[] selection) {
        int n = column.getPositionCount();
        for (int i = 0; i < n; ++i) {
            if (selection[i] && !column.isNull(i)) {
                columnBuilder.writeLong(this.evaluateFunction.apply(column.getLong(i)).longValue());
                continue;
            }
            columnBuilder.appendNull();
        }
    }
}

