/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.util;

import com.codahale.metrics.Timer;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import org.apache.ignite3.raft.jraft.util.LogScheduledThreadPoolExecutor;
import org.apache.ignite3.raft.jraft.util.ThreadPoolMetricRegistry;

public class MetricScheduledThreadPoolExecutor
extends LogScheduledThreadPoolExecutor {
    public MetricScheduledThreadPoolExecutor(int corePoolSize, String name) {
        super(corePoolSize, name);
    }

    public MetricScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory, String name) {
        super(corePoolSize, threadFactory, name);
    }

    public MetricScheduledThreadPoolExecutor(int corePoolSize, RejectedExecutionHandler handler, String name) {
        super(corePoolSize, handler, name);
    }

    public MetricScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory, RejectedExecutionHandler handler, String name) {
        super(corePoolSize, threadFactory, handler, name);
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        super.beforeExecute(t, r);
        try {
            ThreadPoolMetricRegistry.timerThreadLocal().set(ThreadPoolMetricRegistry.metricRegistry().timer("scheduledThreadPool." + this.getName()).time());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        try {
            ThreadLocal<Timer.Context> tl = ThreadPoolMetricRegistry.timerThreadLocal();
            Timer.Context ctx = tl.get();
            if (ctx != null) {
                ctx.stop();
                tl.remove();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

