/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.message;

import java.util.UUID;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;
import org.apache.ignite3.internal.sql.engine.message.QueryStartResponse;
import org.apache.ignite3.internal.sql.engine.message.QueryStartResponseBuilder;
import org.apache.ignite3.internal.sql.engine.message.SqlQueryMessagesFactory;

class QueryStartResponseDeserializer
implements MessageDeserializer<QueryStartResponse> {
    private final QueryStartResponseBuilder msg;

    QueryStartResponseDeserializer(SqlQueryMessagesFactory messageFactory) {
        this.msg = messageFactory.queryStartResponse();
    }

    @Override
    public Class<QueryStartResponse> klass() {
        return QueryStartResponse.class;
    }

    @Override
    public QueryStartResponse getMessage() {
        return this.msg.build();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                byte[] tmp = reader.readByteArray("errorByteArray");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.errorByteArray(tmp);
                reader.incrementState();
            }
            case 1: {
                int tmp = reader.readInt("executionToken");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.executionToken(tmp);
                reader.incrementState();
            }
            case 2: {
                long tmp = reader.readLong("fragmentId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.fragmentId(tmp);
                reader.incrementState();
            }
            case 3: {
                UUID tmp = reader.readUuid("queryId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.queryId(tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(QueryStartResponse.class);
    }
}

