/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.network.serialization.marshal;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.IntFunction;
import org.apache.ignite3.internal.network.serialization.BuiltInType;
import org.apache.ignite3.internal.network.serialization.ClassDescriptor;
import org.apache.ignite3.internal.network.serialization.marshal.BuiltInMarshalling;
import org.apache.ignite3.internal.network.serialization.marshal.MarshalException;
import org.apache.ignite3.internal.network.serialization.marshal.MarshallingContext;
import org.apache.ignite3.internal.network.serialization.marshal.ProtocolMarshalling;
import org.apache.ignite3.internal.network.serialization.marshal.TypedValueReader;
import org.apache.ignite3.internal.network.serialization.marshal.TypedValueWriter;
import org.apache.ignite3.internal.network.serialization.marshal.UnmarshalException;
import org.apache.ignite3.internal.network.serialization.marshal.UnmarshallingContext;
import org.apache.ignite3.internal.network.serialization.marshal.ValueReader;
import org.apache.ignite3.internal.network.serialization.marshal.ValueWriter;
import org.apache.ignite3.internal.util.io.IgniteDataInput;
import org.apache.ignite3.internal.util.io.IgniteDataOutput;

class BuiltInContainerMarshallers {
    private final Int2ObjectMap<IntFunction<? extends Collection<?>>> mutableBuiltInCollectionFactories = Int2ObjectMaps.unmodifiable((Int2ObjectMap)new Int2ObjectOpenHashMap(Map.of(BuiltInType.ARRAY_LIST.descriptorId(), ArrayList::new, BuiltInType.LINKED_LIST.descriptorId(), size -> new LinkedList(), BuiltInType.HASH_SET.descriptorId(), HashSet::new, BuiltInType.LINKED_HASH_SET.descriptorId(), LinkedHashSet::new)));
    private final Int2ObjectMap<IntFunction<? extends Map<?, ?>>> mutableBuiltInMapFactories = Int2ObjectMaps.unmodifiable((Int2ObjectMap)new Int2ObjectOpenHashMap(Map.of(BuiltInType.HASH_MAP.descriptorId(), HashMap::new, BuiltInType.LINKED_HASH_MAP.descriptorId(), LinkedHashMap::new)));
    private final TypedValueWriter typedWriter;
    private final ValueWriter<Object> untypedWriter;
    private final TypedValueReader typedReader;

    BuiltInContainerMarshallers(TypedValueWriter typedWriter, TypedValueReader typedReader) {
        this.typedWriter = typedWriter;
        this.untypedWriter = (obj, out, ctx) -> typedWriter.write(obj, null, out, ctx);
        this.typedReader = typedReader;
    }

    void writeGenericRefArray(Object[] array, ClassDescriptor arrayDescriptor, IgniteDataOutput output, MarshallingContext context) throws IOException, MarshalException {
        Class<?> componentType = array.getClass().getComponentType();
        BuiltInMarshalling.writeClass(componentType, output);
        ProtocolMarshalling.writeLength(array.length, output);
        if (array.length > 0 && arrayDescriptor.isComponentSerializationTypeKnownUpfront()) {
            BitSet nullsBitSet = new BitSet(array.length);
            for (int i = 0; i < array.length; ++i) {
                if (array[i] != null) continue;
                nullsBitSet.set(i);
            }
            BuiltInMarshalling.writeBitSet(nullsBitSet, output);
        }
        for (Object object : array) {
            this.typedWriter.write(object, arrayDescriptor.componentTypeDescriptor(), output, context);
        }
        context.addUsedDescriptor(arrayDescriptor);
    }

    <T> T[] preInstantiateGenericRefArray(DataInput input, UnmarshallingContext context) throws IOException, UnmarshalException {
        return BuiltInMarshalling.preInstantiateGenericRefArray(input, context);
    }

    <T> void fillGenericRefArrayFrom(IgniteDataInput input, T[] array, ClassDescriptor arrayDescriptor, UnmarshallingContext context) throws IOException, UnmarshalException {
        if (array.length == 0) {
            return;
        }
        if (arrayDescriptor.isComponentSerializationTypeKnownUpfront()) {
            BitSet nullsBitSet = BuiltInMarshalling.readBitSet(input);
            for (int i = 0; i < array.length; ++i) {
                if (nullsBitSet.get(i)) continue;
                array[i] = this.typedReader.read(input, arrayDescriptor.componentTypeDescriptor(), context);
            }
        } else {
            for (int i = 0; i < array.length; ++i) {
                array[i] = this.typedReader.read(input, arrayDescriptor.componentTypeDescriptor(), context);
            }
        }
    }

    boolean supportsCollection(ClassDescriptor descriptor) {
        return descriptor.isSingletonList() || this.supportsAsMutableBuiltInCollection(descriptor);
    }

    void writeBuiltInCollection(Collection<?> object, ClassDescriptor descriptor, IgniteDataOutput output, MarshallingContext context) throws IOException, MarshalException {
        if (this.supportsAsMutableBuiltInCollection(descriptor)) {
            this.writeCollection(object, descriptor, output, context);
        } else if (descriptor.isSingletonList()) {
            this.writeSingletonList((List)object, descriptor, output, context);
        } else {
            throw new IllegalStateException("Marshalling of " + descriptor.className() + " is not supported, but it's marked as a built-in");
        }
    }

    private boolean supportsAsMutableBuiltInCollection(ClassDescriptor descriptor) {
        return this.mutableBuiltInCollectionFactories.containsKey(descriptor.descriptorId());
    }

    private void writeCollection(Collection<?> collection, ClassDescriptor collectionDescriptor, IgniteDataOutput output, MarshallingContext context) throws IOException, MarshalException {
        BuiltInMarshalling.writeCollection(collection, output, this.untypedWriter(), context);
        context.addUsedDescriptor(collectionDescriptor);
    }

    private <T> ValueWriter<T> untypedWriter() {
        return this.untypedWriter;
    }

    private void writeSingletonList(List<?> list, ClassDescriptor listDescriptor, IgniteDataOutput output, MarshallingContext context) throws MarshalException, IOException {
        assert (list.size() == 1);
        Object element = list.get(0);
        context.addUsedDescriptor(listDescriptor);
        this.typedWriter.write(element, null, output, context);
    }

    private <T, C extends Collection<T>> IntFunction<C> requiredCollectionFactory(ClassDescriptor collectionDescriptor) {
        IntFunction collectionFactory = (IntFunction)this.mutableBuiltInCollectionFactories.get(collectionDescriptor.descriptorId());
        if (collectionFactory == null) {
            throw new IllegalStateException("Did not find a collection factory for " + collectionDescriptor.className() + " even though it is marked as a built-in");
        }
        return collectionFactory;
    }

    Object preInstantiateBuiltInMutableCollection(ClassDescriptor collectionDescriptor, DataInput input, UnmarshallingContext context) throws IOException {
        if (collectionDescriptor.isSingletonList()) {
            return Collections.singletonList(null);
        }
        return this.preInstantiateNonSingletonCollection(collectionDescriptor, input, context);
    }

    private <T, C extends Collection<T>> C preInstantiateNonSingletonCollection(ClassDescriptor collectionDescriptor, DataInput input, UnmarshallingContext context) throws IOException {
        IntFunction<C> collectionFactory = this.requiredCollectionFactory(collectionDescriptor);
        context.markSource(4);
        C collection = BuiltInMarshalling.preInstantiateCollection(input, collectionFactory);
        context.resetSourceToMark();
        return collection;
    }

    <T, C extends Collection<T>> void fillBuiltInCollectionFrom(IgniteDataInput input, C collection, ClassDescriptor collectionDescriptor, ValueReader<T> elementReader, UnmarshallingContext context) throws UnmarshalException, IOException {
        if (collectionDescriptor.isSingletonList()) {
            BuiltInMarshalling.fillSingletonCollectionFrom(input, collection, elementReader, context);
            return;
        }
        BuiltInMarshalling.fillCollectionFrom(input, collection, elementReader, context);
    }

    void writeBuiltInMap(Map<?, ?> map, ClassDescriptor mapDescriptor, IgniteDataOutput output, MarshallingContext context) throws MarshalException, IOException {
        if (!this.supportsAsBuiltInMap(mapDescriptor)) {
            throw new IllegalStateException("Marshalling of " + mapDescriptor.className() + " is not supported, but it's marked as a built-in");
        }
        context.addUsedDescriptor(mapDescriptor);
        BuiltInMarshalling.writeMap(map, output, this.untypedWriter(), this.untypedWriter(), context);
    }

    boolean supportsAsBuiltInMap(ClassDescriptor mapDescriptor) {
        return this.mutableBuiltInMapFactories.containsKey(mapDescriptor.descriptorId());
    }

    <K, V, M extends Map<K, V>> M preInstantiateBuiltInMutableMap(ClassDescriptor mapDescriptor, DataInput input, UnmarshallingContext context) throws IOException {
        IntFunction<M> mapFactory = this.requiredMapFactory(mapDescriptor);
        context.markSource(4);
        M map = BuiltInMarshalling.preInstantiateMap(input, mapFactory);
        context.resetSourceToMark();
        return map;
    }

    private <K, V, M extends Map<K, V>> IntFunction<M> requiredMapFactory(ClassDescriptor mapDescriptor) {
        IntFunction mapFactory = (IntFunction)this.mutableBuiltInMapFactories.get(mapDescriptor.descriptorId());
        if (mapFactory == null) {
            throw new IllegalStateException("Did not find a map factory for " + mapDescriptor.className() + " even though it is marked as a built-in");
        }
        return mapFactory;
    }

    <K, V, M extends Map<K, V>> void fillBuiltInMapFrom(IgniteDataInput input, M map, ValueReader<K> keyReader, ValueReader<V> valueReader, UnmarshallingContext context) throws UnmarshalException, IOException {
        BuiltInMarshalling.fillMapFrom(input, map, keyReader, valueReader, context);
    }
}

