/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.fluent;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hc.client5.http.auth.AuthCache;
import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.CredentialsStore;
import org.apache.hc.client5.http.auth.NTCredentials;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.cookie.CookieStore;
import org.apache.hc.client5.http.fluent.Request;
import org.apache.hc.client5.http.fluent.Response;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.async.HttpAsyncClientBuilder;
import org.apache.hc.client5.http.impl.auth.BasicAuthCache;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.auth.BasicScheme;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.compat.ClassicToAsyncAdaptor;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.annotation.Experimental;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;

public class Executor {
    private static final ReentrantLock LOCK = new ReentrantLock();
    private static volatile CloseableHttpClient CLIENT;
    private static volatile CloseableHttpClient ASYNC_CLIENT;
    private final CloseableHttpClient httpclient;
    private final AuthCache authCache;
    private volatile CredentialsStore credentialsStore;
    private volatile CookieStore cookieStore;

    static CloseableHttpClient GET_CLASSIC_CLIENT() {
        CloseableHttpClient client = CLIENT;
        if (client != null) {
            return client;
        }
        LOCK.lock();
        try {
            if (CLIENT == null) {
                CLIENT = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)PoolingHttpClientConnectionManagerBuilder.create().useSystemProperties().setMaxConnPerRoute(100).setMaxConnTotal(200).setDefaultConnectionConfig(ConnectionConfig.custom().setValidateAfterInactivity(TimeValue.ofSeconds((long)10L)).build()).build()).useSystemProperties().evictExpiredConnections().evictIdleConnections(TimeValue.ofMinutes((long)1L)).build();
            }
            CloseableHttpClient closeableHttpClient = CLIENT;
            return closeableHttpClient;
        }
        finally {
            LOCK.unlock();
        }
    }

    static CloseableHttpClient GET_ASYNC_CLIENT() {
        CloseableHttpClient client = ASYNC_CLIENT;
        if (client != null) {
            return client;
        }
        LOCK.lock();
        try {
            if (ASYNC_CLIENT == null) {
                ASYNC_CLIENT = new ClassicToAsyncAdaptor(HttpAsyncClientBuilder.create().setConnectionManager((AsyncClientConnectionManager)PoolingAsyncClientConnectionManagerBuilder.create().useSystemProperties().setMaxConnPerRoute(100).setMaxConnTotal(200).setMessageMultiplexing(true).setDefaultConnectionConfig(ConnectionConfig.custom().setValidateAfterInactivity(TimeValue.ofSeconds((long)10L)).build()).build()).useSystemProperties().evictExpiredConnections().evictIdleConnections(TimeValue.ofMinutes((long)1L)).build(), Timeout.ofMinutes((long)5L));
            }
            CloseableHttpClient closeableHttpClient = ASYNC_CLIENT;
            return closeableHttpClient;
        }
        finally {
            LOCK.unlock();
        }
    }

    public static Executor newInstance() {
        return new Executor(Executor.GET_CLASSIC_CLIENT());
    }

    public static Executor newInstance(CloseableHttpClient httpclient) {
        return new Executor(httpclient != null ? httpclient : Executor.GET_CLASSIC_CLIENT());
    }

    @Experimental
    public static Executor newInstance(CloseableHttpAsyncClient httpclient) {
        return new Executor((CloseableHttpClient)(httpclient != null ? new ClassicToAsyncAdaptor(httpclient, Timeout.ofMinutes((long)5L)) : Executor.GET_ASYNC_CLIENT()));
    }

    Executor(CloseableHttpClient httpclient) {
        this.httpclient = httpclient;
        this.authCache = new BasicAuthCache();
    }

    public Executor use(CredentialsStore credentialsStore) {
        this.credentialsStore = credentialsStore;
        return this;
    }

    public Executor auth(AuthScope authScope, Credentials credentials) {
        CredentialsStore credentialsStoreSnapshot = this.credentialsStore;
        if (credentialsStoreSnapshot == null) {
            this.credentialsStore = credentialsStoreSnapshot = new BasicCredentialsProvider();
        }
        credentialsStoreSnapshot.setCredentials(authScope, credentials);
        return this;
    }

    public Executor auth(HttpHost host, Credentials credentials) {
        return this.auth(new AuthScope(host), credentials);
    }

    public Executor auth(String host, Credentials credentials) {
        HttpHost httpHost;
        try {
            httpHost = HttpHost.create((String)host);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException("Invalid host: " + host);
        }
        return this.auth(httpHost, credentials);
    }

    public Executor authPreemptive(HttpHost host) {
        Credentials credentials;
        CredentialsStore credentialsStoreSnapshot = this.credentialsStore;
        if (credentialsStoreSnapshot != null && (credentials = credentialsStoreSnapshot.getCredentials(new AuthScope(host), null)) != null) {
            BasicScheme basicScheme = new BasicScheme();
            basicScheme.initPreemptive(credentials);
            this.authCache.put(host, (AuthScheme)basicScheme);
        }
        return this;
    }

    public Executor authPreemptive(String host) {
        HttpHost httpHost;
        try {
            httpHost = HttpHost.create((String)host);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException("Invalid host: " + host);
        }
        return this.authPreemptive(httpHost);
    }

    public Executor authPreemptiveProxy(HttpHost proxy) {
        Credentials credentials;
        CredentialsStore credentialsStoreSnapshot = this.credentialsStore;
        if (credentialsStoreSnapshot != null && (credentials = credentialsStoreSnapshot.getCredentials(new AuthScope(proxy), null)) != null) {
            BasicScheme basicScheme = new BasicScheme();
            basicScheme.initPreemptive(credentials);
            this.authCache.put(proxy, (AuthScheme)basicScheme);
        }
        return this;
    }

    public Executor authPreemptiveProxy(String proxy) {
        HttpHost httpHost;
        try {
            httpHost = HttpHost.create((String)proxy);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException("Invalid host: " + proxy);
        }
        return this.authPreemptiveProxy(httpHost);
    }

    public Executor auth(HttpHost host, String username, char[] password) {
        return this.auth(host, (Credentials)new UsernamePasswordCredentials(username, password));
    }

    @Deprecated
    public Executor auth(HttpHost host, String username, char[] password, String workstation, String domain) {
        return this.auth(host, (Credentials)new NTCredentials(username, password, workstation, domain));
    }

    public Executor clearAuth() {
        CredentialsStore credentialsStoreSnapshot = this.credentialsStore;
        if (credentialsStoreSnapshot != null) {
            credentialsStoreSnapshot.clear();
        }
        return this;
    }

    public Executor use(CookieStore cookieStore) {
        this.cookieStore = cookieStore;
        return this;
    }

    public Executor clearCookies() {
        CookieStore cookieStoreSnapshot = this.cookieStore;
        if (cookieStoreSnapshot != null) {
            cookieStoreSnapshot.clear();
        }
        return this;
    }

    public Response execute(Request request) throws IOException {
        CookieStore cookieStoreSnapshot;
        HttpClientContext localContext = HttpClientContext.create();
        CredentialsStore credentialsStoreSnapshot = this.credentialsStore;
        if (credentialsStoreSnapshot != null) {
            localContext.setCredentialsProvider((CredentialsProvider)credentialsStoreSnapshot);
        }
        if (this.authCache != null) {
            localContext.setAuthCache(this.authCache);
        }
        if ((cookieStoreSnapshot = this.cookieStore) != null) {
            localContext.setCookieStore(cookieStoreSnapshot);
        }
        return new Response(request.internalExecute(this.httpclient, localContext));
    }
}

