/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.io.entity;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.io.entity.EmptyInputStream;
import org.apache.hc.core5.http.io.entity.InputStreamEntity;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestInputStreamEntity {
    TestInputStreamEntity() {
    }

    @Test
    void testBasics() throws Exception {
        byte[] bytes = "Message content".getBytes(StandardCharsets.US_ASCII);
        InputStreamEntity entity = new InputStreamEntity((InputStream)new ByteArrayInputStream(bytes), (long)bytes.length, null);
        Assertions.assertEquals((long)bytes.length, (long)entity.getContentLength());
        Assertions.assertNotNull((Object)entity.getContent());
        Assertions.assertFalse((boolean)entity.isRepeatable());
        Assertions.assertTrue((boolean)entity.isStreaming());
    }

    @Test
    void testNullConstructor() {
        Assertions.assertThrows(NullPointerException.class, () -> new InputStreamEntity(null, 0L, null));
    }

    @Test
    void testUnknownLengthConstructor() throws Exception {
        try (InputStreamEntity entity = new InputStreamEntity((InputStream)EmptyInputStream.INSTANCE, null);){
            Assertions.assertEquals((long)-1L, (long)entity.getContentLength());
        }
    }

    @Test
    void testWriteTo() throws Exception {
        String message = "Message content";
        byte[] bytes = "Message content".getBytes(StandardCharsets.US_ASCII);
        ByteArrayInputStream inStream = new ByteArrayInputStream(bytes);
        try (InputStreamEntity entity = new InputStreamEntity((InputStream)inStream, (long)bytes.length, ContentType.TEXT_PLAIN.withCharset(StandardCharsets.US_ASCII));){
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            entity.writeTo((OutputStream)out);
            byte[] writtenBytes = out.toByteArray();
            Assertions.assertNotNull((Object)writtenBytes);
            Assertions.assertEquals((int)bytes.length, (int)writtenBytes.length);
            String s = new String(writtenBytes, StandardCharsets.US_ASCII.name());
            Assertions.assertEquals((Object)"Message content", (Object)s);
        }
    }

    @Test
    void testWriteToPartialContent() throws Exception {
        String message = "Message content";
        byte[] bytes = "Message content".getBytes(StandardCharsets.US_ASCII);
        ByteArrayInputStream inStream = new ByteArrayInputStream(bytes);
        int contentLength = 7;
        try (InputStreamEntity entity = new InputStreamEntity((InputStream)inStream, 7L, ContentType.TEXT_PLAIN.withCharset(StandardCharsets.US_ASCII));){
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            entity.writeTo((OutputStream)out);
            byte[] writtenBytes = out.toByteArray();
            Assertions.assertNotNull((Object)writtenBytes);
            Assertions.assertEquals((int)7, (int)writtenBytes.length);
            String s = new String(writtenBytes, StandardCharsets.US_ASCII.name());
            Assertions.assertEquals((Object)"Message content".substring(0, 7), (Object)s);
        }
    }

    @Test
    void testWriteToUnknownLength() throws Exception {
        String message = "Message content";
        byte[] bytes = "Message content".getBytes(StandardCharsets.US_ASCII);
        InputStreamEntity entity = new InputStreamEntity((InputStream)new ByteArrayInputStream(bytes), ContentType.TEXT_PLAIN.withCharset(StandardCharsets.US_ASCII));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        entity.writeTo((OutputStream)out);
        byte[] writtenBytes = out.toByteArray();
        Assertions.assertNotNull((Object)writtenBytes);
        Assertions.assertEquals((int)bytes.length, (int)writtenBytes.length);
        String s = new String(writtenBytes, StandardCharsets.US_ASCII.name());
        Assertions.assertEquals((Object)"Message content", (Object)s);
    }

    @Test
    void testWriteToNull() throws Exception {
        try (InputStreamEntity entity = new InputStreamEntity((InputStream)EmptyInputStream.INSTANCE, 0L, null);){
            Assertions.assertThrows(NullPointerException.class, () -> entity.writeTo(null));
        }
    }
}

