/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.util;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;

public abstract class UriUtils {
    private static final String SLASH_STR = "/";
    private static final char DOT = '.';
    private static final char SLASH = '/';

    public static String concat(String path1, String path2) {
        if (path1 == null && path2 == null) {
            return null;
        }
        if (path1 == null) {
            path1 = "";
        }
        if (path2 == null) {
            path2 = "";
        }
        if (UriUtils.isEmpty(path1) && UriUtils.isEmpty(path2)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int idx = path1.indexOf(63);
        if (idx == 0) {
            return path2.concat(path1);
        }
        if (idx > 0) {
            sb.append(path1.substring(0, idx));
        } else {
            sb.append(path1);
        }
        if (UriUtils.endsWith(sb, SLASH_STR)) {
            if (path2.startsWith(SLASH_STR)) {
                sb.append(path2.substring(1));
            } else {
                sb.append(path2);
            }
        } else if (path2.startsWith(SLASH_STR)) {
            sb.append(path2);
        } else if (sb.length() > 0 && !UriUtils.isEmpty(path2)) {
            sb.append(SLASH_STR).append(path2);
        } else {
            sb.append(path2);
        }
        if (idx > 0) {
            sb.append(path1.substring(idx, path1.length()));
        }
        return sb.toString();
    }

    public static String decodePath(String path) {
        return UriUtils.decodePath(path, "UTF-8");
    }

    private static String decodePath(String path, String encoding) {
        if (path == null) {
            return null;
        }
        CharsetDecoder decoder = Charset.forName(encoding).newDecoder();
        decoder.onMalformedInput(CodingErrorAction.REPORT);
        decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        int len = path.length();
        ByteBuffer buf = ByteBuffer.allocate(len);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            char ch = path.charAt(i);
            if (ch == '%' && i + 2 < len) {
                buf.put((byte)(16 * UriUtils.hexVal(path, ++i) + UriUtils.hexVal(path, ++i)));
                continue;
            }
            if (buf.position() > 0) {
                sb.append(UriUtils.decode(buf, decoder));
                buf.clear();
            }
            sb.append(ch);
        }
        if (buf.position() > 0) {
            sb.append(UriUtils.decode(buf, decoder));
            buf.clear();
        }
        return sb.toString();
    }

    public static String removeDotSegments(String path) {
        if (path == null) {
            return null;
        }
        if (UriUtils.isEmpty(path)) {
            return "";
        }
        StringBuilder scratch = new StringBuilder(path);
        StringBuilder sb = new StringBuilder();
        char la = '\u0000';
        char laa = '\u0000';
        char laaa = '\u0000';
        while (scratch.length() > 0) {
            char l = UriUtils.la(scratch, 0);
            la = UriUtils.la(scratch, 1);
            laa = UriUtils.la(scratch, 2);
            if (l == '.') {
                if (la == '\u0000') break;
                if (la == '.' && laa == '/') {
                    scratch.delete(0, 3);
                    continue;
                }
                if (la == '.' && laa == '\u0000') break;
                if (la == '/') {
                    scratch.delete(0, 2);
                    continue;
                }
            } else if (l == '/' && la == '.') {
                if (laa == '/') {
                    scratch.delete(0, 2);
                    continue;
                }
                if (laa == '\u0000') {
                    sb.append('/');
                    break;
                }
                if (laa == '.') {
                    laaa = UriUtils.la(scratch, 3);
                    if (laaa == '/') {
                        scratch.delete(0, 3);
                        sb.setLength(UriUtils.lb(sb, 0));
                        continue;
                    }
                    if (laaa == '\u0000') {
                        sb.setLength(UriUtils.lb(sb, -1));
                        break;
                    }
                }
            }
            do {
                sb.append(l);
                scratch.delete(0, 1);
            } while ((l = UriUtils.la(scratch, 0)) != '/' && l != '\u0000');
        }
        return sb.toString();
    }

    private static char la(CharSequence sb, int idx) {
        if (sb.length() > idx) {
            return sb.charAt(idx);
        }
        return '\u0000';
    }

    private static int lb(CharSequence sb, int offset) {
        int pos;
        for (pos = sb.length() - 1 - offset; pos > 0 && sb.charAt(pos + offset) != '/'; --pos) {
        }
        return pos;
    }

    private static String decode(ByteBuffer bb, CharsetDecoder decoder) {
        CharBuffer cb = CharBuffer.allocate(128);
        CoderResult result = decoder.decode(bb.flip(), cb, true);
        if (result.isError()) {
            throw new IllegalArgumentException("Malformed UTF-8!");
        }
        return cb.flip().toString();
    }

    private static boolean endsWith(CharSequence seq, String part) {
        int len = part.length();
        if (seq.length() < len) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (seq.charAt(seq.length() - (i + 1)) == part.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private static int hexVal(CharSequence seq, int idx) {
        char ch = seq.charAt(idx);
        if (ch >= '0' && ch <= '9') {
            return ch - 48;
        }
        if (ch >= 'a' && ch <= 'f') {
            return 10 + (ch - 97);
        }
        if (ch >= 'A' && ch <= 'F') {
            return 10 + (ch - 65);
        }
        throw new IllegalArgumentException("Invalid hex digit: " + ch);
    }

    private static boolean isEmpty(String value) {
        return value == null || "".equals(value.trim());
    }

    private UriUtils() {
    }
}

