/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.common.positional;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import org.apache.datasketches.common.positional.PositionalImpl;
import org.apache.datasketches.common.positional.PositionalSegment;

final class PositionalSegmentImpl
extends PositionalImpl
implements PositionalSegment {
    private static final byte SHORT_SHIFT = 1;
    private static final byte CHAR_SHIFT = 1;
    private static final byte INT_SHIFT = 2;
    private static final byte LONG_SHIFT = 3;
    private static final byte FLOAT_SHIFT = 2;
    private static final byte DOUBLE_SHIFT = 3;
    private final MemorySegment seg;

    PositionalSegmentImpl(MemorySegment seg) {
        super(seg.byteSize());
        this.seg = seg;
    }

    @Override
    public PositionalSegment asSlice() {
        MemorySegment slice = this.seg.asSlice(this.getPosition());
        return new PositionalSegmentImpl(slice);
    }

    @Override
    public MemorySegment getMemorySegment() {
        return this.seg;
    }

    @Override
    public boolean getBoolean() {
        return this.getByte() != 0;
    }

    @Override
    public boolean getBoolean(long offsetBytes) {
        return this.getByte(offsetBytes) != 0;
    }

    @Override
    public byte getByte() {
        byte aByte = this.seg.get(ValueLayout.JAVA_BYTE, this.getPosition());
        this.incrementPosition(1L);
        return aByte;
    }

    @Override
    public byte getByte(long offsetBytes) {
        return this.seg.get(ValueLayout.JAVA_BYTE, offsetBytes);
    }

    @Override
    public void getByteArray(byte[] dstArray, int dstOffsetBytes, int lengthBytes) {
        MemorySegment.copy(this.seg, ValueLayout.JAVA_BYTE, this.getPosition(), dstArray, dstOffsetBytes, lengthBytes);
        this.incrementPosition(lengthBytes);
    }

    @Override
    public char getChar() {
        char achar = this.seg.get(ValueLayout.JAVA_CHAR_UNALIGNED, this.getPosition());
        this.incrementPosition(2L);
        return achar;
    }

    @Override
    public char getChar(long offsetBytes) {
        return this.seg.get(ValueLayout.JAVA_CHAR_UNALIGNED, offsetBytes);
    }

    @Override
    public void getCharArray(char[] dstArray, int dstOffsetChars, int lengthChars) {
        MemorySegment.copy(this.seg, ValueLayout.JAVA_CHAR_UNALIGNED, this.getPosition(), dstArray, dstOffsetChars, lengthChars);
        this.incrementPosition(lengthChars << 1);
    }

    @Override
    public double getDouble() {
        double dbl = this.seg.get(ValueLayout.JAVA_DOUBLE_UNALIGNED, this.getPosition());
        this.incrementPosition(8L);
        return dbl;
    }

    @Override
    public double getDouble(long offsetBytes) {
        return this.seg.get(ValueLayout.JAVA_DOUBLE_UNALIGNED, offsetBytes);
    }

    @Override
    public void getDoubleArray(double[] dstArray, int dstOffsetDoubles, int lengthDoubles) {
        MemorySegment.copy(this.seg, ValueLayout.JAVA_DOUBLE_UNALIGNED, this.getPosition(), dstArray, dstOffsetDoubles, lengthDoubles);
        this.incrementPosition(lengthDoubles << 3);
    }

    @Override
    public float getFloat() {
        float flt = this.seg.get(ValueLayout.JAVA_FLOAT_UNALIGNED, this.getPosition());
        this.incrementPosition(4L);
        return flt;
    }

    @Override
    public float getFloat(long offsetBytes) {
        return this.seg.get(ValueLayout.JAVA_FLOAT_UNALIGNED, offsetBytes);
    }

    @Override
    public void getFloatArray(float[] dstArray, int dstOffsetFloats, int lengthFloats) {
        MemorySegment.copy(this.seg, ValueLayout.JAVA_FLOAT_UNALIGNED, this.getPosition(), dstArray, dstOffsetFloats, lengthFloats);
        this.incrementPosition(lengthFloats << 2);
    }

    @Override
    public int getInt() {
        int i = this.seg.get(ValueLayout.JAVA_INT_UNALIGNED, this.getPosition());
        this.incrementPosition(4L);
        return i;
    }

    @Override
    public int getInt(long offsetBytes) {
        return this.seg.get(ValueLayout.JAVA_INT_UNALIGNED, offsetBytes);
    }

    @Override
    public void getIntArray(int[] dstArray, int dstOffsetInts, int lengthInts) {
        MemorySegment.copy(this.seg, ValueLayout.JAVA_INT_UNALIGNED, this.getPosition(), dstArray, dstOffsetInts, lengthInts);
        this.incrementPosition(lengthInts << 2);
    }

    @Override
    public long getLong() {
        long along = this.seg.get(ValueLayout.JAVA_LONG_UNALIGNED, this.getPosition());
        this.incrementPosition(8L);
        return along;
    }

    @Override
    public long getLong(long offsetBytes) {
        return this.seg.get(ValueLayout.JAVA_LONG_UNALIGNED, offsetBytes);
    }

    @Override
    public void getLongArray(long[] dstArray, int dstOffsetLongs, int lengthLongs) {
        MemorySegment.copy(this.seg, ValueLayout.JAVA_LONG_UNALIGNED, this.getPosition(), dstArray, dstOffsetLongs, lengthLongs);
        this.incrementPosition(lengthLongs << 3);
    }

    @Override
    public short getShort() {
        short ashort = this.seg.get(ValueLayout.JAVA_SHORT_UNALIGNED, this.getPosition());
        this.incrementPosition(2L);
        return ashort;
    }

    @Override
    public short getShort(long offsetBytes) {
        return this.seg.get(ValueLayout.JAVA_SHORT_UNALIGNED, offsetBytes);
    }

    @Override
    public void getShortArray(short[] dstArray, int dstOffsetShorts, int lengthShorts) {
        MemorySegment.copy(this.seg, ValueLayout.JAVA_SHORT_UNALIGNED, this.getPosition(), dstArray, dstOffsetShorts, lengthShorts);
        this.incrementPosition(lengthShorts << 1);
    }

    @Override
    public void setBoolean(boolean value) {
        this.setByte(value ? (byte)1 : 0);
    }

    @Override
    public void setBoolean(long offsetBytes, boolean value) {
        this.setByte(offsetBytes, value ? (byte)1 : 0);
    }

    @Override
    public void setByte(byte value) {
        this.seg.set(ValueLayout.JAVA_BYTE, this.getPosition(), value);
        this.incrementPosition(1L);
    }

    @Override
    public void setByte(long offsetBytes, byte value) {
        this.seg.set(ValueLayout.JAVA_BYTE, offsetBytes, value);
    }

    @Override
    public void setByteArray(byte[] srcArray, int srcOffsetBytes, int lengthBytes) {
        MemorySegment.copy(srcArray, srcOffsetBytes, this.seg, ValueLayout.JAVA_BYTE, this.getPosition(), lengthBytes);
        this.incrementPosition(lengthBytes);
    }

    @Override
    public void setChar(char value) {
        this.seg.set(ValueLayout.JAVA_CHAR_UNALIGNED, this.getPosition(), value);
        this.incrementPosition(2L);
    }

    @Override
    public void setChar(long offsetBytes, char value) {
        this.seg.set(ValueLayout.JAVA_CHAR_UNALIGNED, offsetBytes, value);
    }

    @Override
    public void setCharArray(char[] srcArray, int srcOffsetChars, int lengthChars) {
        MemorySegment.copy(srcArray, srcOffsetChars, this.seg, ValueLayout.JAVA_CHAR_UNALIGNED, this.getPosition(), lengthChars);
        this.incrementPosition(lengthChars << 1);
    }

    @Override
    public void setDouble(double value) {
        this.seg.set(ValueLayout.JAVA_DOUBLE_UNALIGNED, this.getPosition(), value);
        this.incrementPosition(8L);
    }

    @Override
    public void setDouble(long offsetBytes, double value) {
        this.seg.set(ValueLayout.JAVA_DOUBLE_UNALIGNED, offsetBytes, value);
    }

    @Override
    public void setDoubleArray(double[] srcArray, int srcOffsetDoubles, int lengthDoubles) {
        MemorySegment.copy(srcArray, srcOffsetDoubles, this.seg, ValueLayout.JAVA_DOUBLE_UNALIGNED, this.getPosition(), lengthDoubles);
        this.incrementPosition(lengthDoubles << 3);
    }

    @Override
    public void setFloat(float value) {
        this.seg.set(ValueLayout.JAVA_FLOAT_UNALIGNED, this.getPosition(), value);
        this.incrementPosition(4L);
    }

    @Override
    public void setFloat(long offsetBytes, float value) {
        this.seg.set(ValueLayout.JAVA_FLOAT_UNALIGNED, offsetBytes, value);
    }

    @Override
    public void setFloatArray(float[] srcArray, int srcOffsetFloats, int lengthFloats) {
        MemorySegment.copy(srcArray, srcOffsetFloats, this.seg, ValueLayout.JAVA_FLOAT_UNALIGNED, this.getPosition(), lengthFloats);
        this.incrementPosition(lengthFloats << 2);
    }

    @Override
    public void setInt(int value) {
        this.seg.set(ValueLayout.JAVA_INT_UNALIGNED, this.getPosition(), value);
        this.incrementPosition(4L);
    }

    @Override
    public void setInt(long offsetBytes, int value) {
        this.seg.set(ValueLayout.JAVA_INT_UNALIGNED, offsetBytes, value);
    }

    @Override
    public void setIntArray(int[] srcArray, int srcOffsetInts, int lengthInts) {
        MemorySegment.copy(srcArray, srcOffsetInts, this.seg, ValueLayout.JAVA_INT_UNALIGNED, this.getPosition(), lengthInts);
        this.incrementPosition(lengthInts << 2);
    }

    @Override
    public void setLong(long value) {
        this.seg.set(ValueLayout.JAVA_LONG_UNALIGNED, this.getPosition(), value);
        this.incrementPosition(8L);
    }

    @Override
    public void setLong(long offsetBytes, long value) {
        this.seg.set(ValueLayout.JAVA_LONG_UNALIGNED, offsetBytes, value);
    }

    @Override
    public void setLongArray(long[] srcArray, int srcOffsetLongs, int lengthLongs) {
        MemorySegment.copy(srcArray, srcOffsetLongs, this.seg, ValueLayout.JAVA_LONG_UNALIGNED, this.getPosition(), lengthLongs);
        this.incrementPosition(lengthLongs << 3);
    }

    @Override
    public void setShort(short value) {
        this.seg.set(ValueLayout.JAVA_SHORT_UNALIGNED, this.getPosition(), value);
        this.incrementPosition(2L);
    }

    @Override
    public void setShort(long offsetBytes, short value) {
        this.seg.set(ValueLayout.JAVA_SHORT_UNALIGNED, offsetBytes, value);
    }

    @Override
    public void setShortArray(short[] srcArray, int srcOffsetShorts, int lengthShorts) {
        MemorySegment.copy(srcArray, srcOffsetShorts, this.seg, ValueLayout.JAVA_SHORT_UNALIGNED, this.getPosition(), lengthShorts);
        this.incrementPosition(lengthShorts << 1);
    }
}

