/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.databinding.types;

import java.math.BigInteger;

public class UnsignedLong
extends Number
implements Comparable {
    private static final long serialVersionUID = -5919942584284897583L;
    protected BigInteger lValue = BigInteger.ZERO;
    private static BigInteger MAX = new BigInteger("18446744073709551615");
    private Object __equalsCalc = null;

    public UnsignedLong() {
    }

    public UnsignedLong(double value) throws NumberFormatException {
        this.setValue(new BigInteger(Double.toString(value)));
    }

    public UnsignedLong(BigInteger value) throws NumberFormatException {
        this.setValue(value);
    }

    public UnsignedLong(long lValue) throws IllegalArgumentException {
        this.setValue(BigInteger.valueOf(lValue));
    }

    public UnsignedLong(String stValue) throws NumberFormatException {
        try {
            if (stValue.charAt(0) == '-') {
                throw new NumberFormatException("A String that starts with a minus sign is not a valid representation of an UnsignedLong.");
            }
            this.setValue(new BigInteger(stValue));
        }
        catch (NumberFormatException numberFormatException) {
            throw numberFormatException;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new NumberFormatException("An empty string is not a valid representation of an UnsignedLong.");
        }
    }

    private void setValue(BigInteger val) {
        if (!UnsignedLong.isValid(val)) {
            throw new IllegalArgumentException(String.valueOf(val) + "]");
        }
        this.lValue = val;
    }

    public static boolean isValid(BigInteger value) {
        long unsignedLongValue = value.longValue();
        return UnsignedLong.compare(unsignedLongValue, BigInteger.ZERO.longValue()) >= 0 && UnsignedLong.compare(unsignedLongValue, MAX.longValue()) <= 0;
    }

    public String toString() {
        return this.lValue.toString();
    }

    public int hashCode() {
        if (this.lValue != null) {
            return this.lValue.hashCode();
        }
        return 0;
    }

    public synchronized boolean equals(Object obj) {
        if (!(obj instanceof UnsignedLong)) {
            return false;
        }
        UnsignedLong other = (UnsignedLong)obj;
        if (this == obj) {
            return true;
        }
        if (this.__equalsCalc != null) {
            return this.__equalsCalc == obj;
        }
        this.__equalsCalc = obj;
        boolean _equals = this.lValue == null && other.lValue == null || this.lValue != null && this.lValue.equals(other.lValue);
        this.__equalsCalc = null;
        return _equals;
    }

    @Override
    public byte byteValue() {
        return this.lValue.byteValue();
    }

    @Override
    public short shortValue() {
        return this.lValue.shortValue();
    }

    @Override
    public int intValue() {
        return this.lValue.intValue();
    }

    @Override
    public long longValue() {
        return this.lValue.longValue();
    }

    @Override
    public double doubleValue() {
        return this.lValue.doubleValue();
    }

    @Override
    public float floatValue() {
        return this.lValue.floatValue();
    }

    public int compareTo(Object o) {
        int retVal = 0;
        if (o == null || !(o instanceof UnsignedLong)) {
            throw new ClassCastException("The argument is not an UnsignedLong.");
        }
        retVal = UnsignedLong.compare(this.longValue(), ((UnsignedLong)o).longValue());
        return retVal;
    }

    private static int compare(long thisLong, long thatLong) {
        boolean isLessThan;
        if (thisLong == thatLong) {
            return 0;
        }
        long thisHalfLong = (thisLong & 0xFFFFFFFF00000000L) >>> 1;
        long thatHalfLong = (thatLong & 0xFFFFFFFF00000000L) >>> 1;
        if (thisHalfLong == thatHalfLong) {
            thisHalfLong = thisLong & 0xFFFFFFFFL;
            thatHalfLong = thatLong & 0xFFFFFFFFL;
            isLessThan = thisHalfLong < thatHalfLong;
        } else {
            boolean bl = isLessThan = thisHalfLong < thatHalfLong;
        }
        if (isLessThan) {
            return -1;
        }
        return 1;
    }
}

