/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.tool.service.swing.ui;

import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.apache.axis2.tool.service.bean.WizardBean;
import org.apache.axis2.tool.service.control.Controller;
import org.apache.axis2.tool.service.control.ProcessException;
import org.apache.axis2.tool.service.swing.ui.WizardPane;
import org.apache.axis2.tool.service.swing.ui.WizardPane1;
import org.apache.axis2.tool.service.swing.ui.WizardPane2;
import org.apache.axis2.tool.service.swing.ui.WizardPane3;

public class MainWindow
extends JFrame {
    private JPanel wizardPaneContainer;
    private JButton nextButton;
    private JButton previousButton;
    private JButton cancelButton;
    private JButton finishButton;
    private int currentPage;
    private WizardPane currentWizardPane;
    private static final int PAGE_1 = 1;
    private static final int PAGE_2 = 2;
    private static final int PAGE_3 = 3;
    private WizardBean wizardBean = new WizardBean();

    public MainWindow() throws HeadlessException {
        super("Axis 2 - Service Jar Builder");
        this.init();
    }

    private void init() {
        this.getContentPane().setLayout(null);
        this.setBounds((int)Toolkit.getDefaultToolkit().getScreenSize().getWidth() / 2 - 200, (int)Toolkit.getDefaultToolkit().getScreenSize().getHeight() / 2 - 180, 400, 360);
        this.setResizable(false);
        this.setDefaultCloseOperation(3);
        int hgap = 5;
        int vgap = 5;
        int bWidth = 80;
        int bHeight = 20;
        this.wizardPaneContainer = new JPanel(null);
        this.getContentPane().add(this.wizardPaneContainer);
        this.wizardPaneContainer.setBounds(0, 0, 400, 300);
        this.previousButton = new JButton("Previous");
        this.getContentPane().add(this.previousButton);
        this.previousButton.setBounds(hgap, 300 + vgap, bWidth, bHeight);
        this.previousButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.moveBackWard();
            }
        });
        this.nextButton = new JButton("Next");
        this.getContentPane().add(this.nextButton);
        this.nextButton.setBounds(hgap + bWidth + hgap, 300 + vgap, bWidth, bHeight);
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.moveForward();
            }
        });
        this.cancelButton = new JButton("Close");
        this.getContentPane().add(this.cancelButton);
        this.cancelButton.setBounds(hgap + (bWidth + hgap) * 2, 300 + vgap, bWidth, bHeight);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MainWindow.this.confirmExit()) {
                    System.exit(0);
                }
            }
        });
        this.finishButton = new JButton("Finish");
        this.getContentPane().add(this.finishButton);
        this.finishButton.setBounds(hgap + (bWidth + hgap) * 3, 300 + vgap, bWidth, bHeight);
        this.finishButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.processFinish();
            }
        });
        this.currentPage = 1;
        this.moveToPage(this.currentPage);
    }

    private void showErrorMessage() {
        JOptionPane.showMessageDialog(this, "Required Value Not set!!!", "Error", 0);
    }

    private void showErrorMessage(String message) {
        JOptionPane.showMessageDialog(this, message, "Error", 0);
    }

    private void showSuccessMessage(String message) {
        JOptionPane.showMessageDialog(this, message, "Error", 1);
    }

    private boolean confirmExit() {
        int returnType = JOptionPane.showOptionDialog(this, "Are you sure you want to exit?", "Exit service builder", 0, 2, null, null, null);
        return returnType == 0;
    }

    private void moveForward() {
        if (this.currentWizardPane.validateValues()) {
            ++this.currentPage;
            this.moveToPage(this.currentPage);
        } else {
            this.showErrorMessage();
        }
    }

    private void moveBackWard() {
        --this.currentPage;
        this.moveToPage(this.currentPage);
    }

    private void moveToPage(int page) {
        switch (page) {
            case 1: {
                this.processPage(new WizardPane1(this.wizardBean, this), false, true, false);
                break;
            }
            case 2: {
                this.processPage(new WizardPane2(this.wizardBean, this), true, true, false);
                break;
            }
            case 3: {
                this.processPage(new WizardPane3(this.wizardBean, this), true, false, true);
                break;
            }
            default: {
                return;
            }
        }
    }

    private void processFinish() {
        if (this.currentWizardPane.validateValues()) {
            try {
                new Controller().process(this.wizardBean);
                this.showSuccessMessage(" jar file creation successful! ");
            }
            catch (ProcessException e) {
                this.showErrorMessage(e.getMessage());
            }
            catch (Exception e) {
                this.showErrorMessage("Unknown Error! " + e.getMessage());
            }
        } else {
            this.showErrorMessage();
        }
    }

    private void processPage(WizardPane pane, boolean prevButtonState, boolean nextButtonState, boolean finishButtonState) {
        this.wizardPaneContainer.removeAll();
        this.currentWizardPane = pane;
        this.wizardPaneContainer.add(pane);
        this.previousButton.setEnabled(prevButtonState);
        this.nextButton.setEnabled(nextButtonState);
        this.finishButton.setEnabled(finishButtonState);
        this.repaint();
    }

    public static void main(String[] args) {
        new MainWindow().show();
    }
}

