/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.http;

import jakarta.servlet.ServletException;
import java.net.URI;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.transport.TransportAcceptListener;
import org.apache.activemq.transport.http.HttpTransportFactory;
import org.apache.activemq.transport.http.HttpTransportServer;
import org.apache.activemq.transport.http.HttpTunnelServlet;

public class HttpEmbeddedTunnelServlet
extends HttpTunnelServlet {
    private static final long serialVersionUID = -3705734740251302361L;
    protected BrokerService broker;
    protected HttpTransportServer transportConnector;

    @Override
    public synchronized void init() throws ServletException {
        try {
            if (this.broker == null) {
                this.broker = this.createBroker();
                String url = this.getConnectorURL();
                HttpTransportFactory factory = new HttpTransportFactory();
                this.transportConnector = (HttpTransportServer)factory.doBind(new URI(url));
                this.broker.addConnector(this.transportConnector);
                String brokerURL = this.getServletContext().getInitParameter("org.apache.activemq.brokerURL");
                if (brokerURL != null) {
                    this.log("Listening for internal communication on: " + brokerURL);
                }
            }
            this.broker.start();
        }
        catch (Exception e) {
            throw new ServletException("Failed to start embedded broker: " + String.valueOf(e), (Throwable)e);
        }
        TransportAcceptListener listener = this.transportConnector.getAcceptListener();
        this.getServletContext().setAttribute("transportChannelListener", (Object)listener);
        super.init();
    }

    protected BrokerService createBroker() throws Exception {
        BrokerService answer = new BrokerService();
        return answer;
    }

    protected String getConnectorURL() {
        return "http://localhost/" + this.getServletContext().getServletContextName();
    }
}

