""" 
   Copyright (C) 2001 PimenTech SARL (http://www.pimentech.net)

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
"""

from map import *

class Set(Map):
	"the set class"

	type = 'Set'
	
	def __init__(self, name = 'Set'):
		Map.__init__(self, name)
		
	def __repr__(self):
		xmlstr = "<set name='%s'>\n" % self.name
		for object in self.values():
			xmlstr = "%s<element>%s</element>\n" % (xmlstr, `object`)
		return "%s</set>" % xmlstr
	
	def insert(self, object):
		if (not self.has_key(object)):
			self[object] = object
			return object
		return self[object]

	def insert_set(self, set):
		return self.insert_map(set)
