# Largest Contentful Paint Changes in M83

## Changes in Chrome 83

Two bugs in the implementation of Largest Contentful Paint (LCP) were fixed
in Chrome 83:
 * Largest Contentful Paint measurement should stop at the first input or
   scroll on the page. In Chrome 83, inputs and scrolls in subframes were
   correctly accounted for. [Source code for this
   change](https://chromium-review.googlesource.com/c/chromium/src/+/2083861).
 * When comparing sizes of images for Largest Contentful Paint, the visual size
   of a background image was previously computed as the size of its Layout
   Object. This is not correct in all cases; for example in the case of CSS
   styles like :first-letter. This issue was fixed in Chrome 83. [Source code
   for this change](https://chromium-review.googlesource.com/c/chromium/src/+/2023523).

## How does this affect a site's metrics?

For the change that stops measuring LCP at input or scroll in any frame, we see
a reduction in LCP at the higher percentiles on Android only (not desktop).
Across all sites that use frames, we see the following impact. Sites should
expect to see different impacts depending on how they use frames.

 * At the 75th percentile, a ~5% drop
 * At the 99th percentile, a ~40% drop

We do not see an impact from the background image change in our overall metrics,
so we believe the effect on most sites will be minimal. For some sites, the
element which is counted as the largest contentful paint could change, and the
metric change would depend on the layout of the site.

## When were users affected?

Chrome 83 is currently scheduled to release on May 19. This page will be updated
with an improved estimate of how sites' metrics are impacted within two weeks of
launch.
