# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import deserialize
from twilio.base import values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class FleetList(ListResource):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version):
        """
        Initialize the FleetList

        :param Version version: Version that contains the resource

        :returns: twilio.rest.supersim.v1.fleet.FleetList
        :rtype: twilio.rest.supersim.v1.fleet.FleetList
        """
        super(FleetList, self).__init__(version)

        # Path Solution
        self._solution = {}
        self._uri = '/Fleets'.format(**self._solution)

    def create(self, network_access_profile, unique_name=values.unset,
               data_enabled=values.unset, data_limit=values.unset,
               commands_enabled=values.unset, commands_url=values.unset,
               commands_method=values.unset):
        """
        Create the FleetInstance

        :param unicode network_access_profile: The SID or unique name of the Network Access Profile of the Fleet
        :param unicode unique_name: An application-defined string that uniquely identifies the resource
        :param bool data_enabled: Defines whether SIMs in the Fleet are capable of using data connectivity
        :param unicode data_limit: The total data usage (download and upload combined) in Megabytes that each Sim resource assigned to the Fleet resource can consume
        :param bool commands_enabled: Defines whether SIMs in the Fleet are capable of sending and receiving machine-to-machine SMS via Commands
        :param unicode commands_url: The URL that will receive a webhook when a SIM in the Fleet originates a machine-to-machine SMS via Commands
        :param unicode commands_method: A string representing the HTTP method to use when making a request to `commands_url`

        :returns: The created FleetInstance
        :rtype: twilio.rest.supersim.v1.fleet.FleetInstance
        """
        data = values.of({
            'NetworkAccessProfile': network_access_profile,
            'UniqueName': unique_name,
            'DataEnabled': data_enabled,
            'DataLimit': data_limit,
            'CommandsEnabled': commands_enabled,
            'CommandsUrl': commands_url,
            'CommandsMethod': commands_method,
        })

        payload = self._version.create(method='POST', uri=self._uri, data=data, )

        return FleetInstance(self._version, payload, )

    def stream(self, network_access_profile=values.unset, limit=None,
               page_size=None):
        """
        Streams FleetInstance records from the API as a generator stream.
        This operation lazily loads records as efficiently as possible until the limit
        is reached.
        The results are returned as a generator, so this operation is memory efficient.

        :param unicode network_access_profile: The SID or unique name of the Network Access Profile of the Fleet
        :param int limit: Upper limit for the number of records to return. stream()
                          guarantees to never return more than limit.  Default is no limit
        :param int page_size: Number of records to fetch per request, when not set will use
                              the default value of 50 records.  If no page_size is defined
                              but a limit is defined, stream() will attempt to read the
                              limit with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        :rtype: list[twilio.rest.supersim.v1.fleet.FleetInstance]
        """
        limits = self._version.read_limits(limit, page_size)

        page = self.page(network_access_profile=network_access_profile, page_size=limits['page_size'], )

        return self._version.stream(page, limits['limit'])

    def list(self, network_access_profile=values.unset, limit=None, page_size=None):
        """
        Lists FleetInstance records from the API as a list.
        Unlike stream(), this operation is eager and will load `limit` records into
        memory before returning.

        :param unicode network_access_profile: The SID or unique name of the Network Access Profile of the Fleet
        :param int limit: Upper limit for the number of records to return. list() guarantees
                          never to return more than limit.  Default is no limit
        :param int page_size: Number of records to fetch per request, when not set will use
                              the default value of 50 records.  If no page_size is defined
                              but a limit is defined, list() will attempt to read the limit
                              with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        :rtype: list[twilio.rest.supersim.v1.fleet.FleetInstance]
        """
        return list(self.stream(
            network_access_profile=network_access_profile,
            limit=limit,
            page_size=page_size,
        ))

    def page(self, network_access_profile=values.unset, page_token=values.unset,
             page_number=values.unset, page_size=values.unset):
        """
        Retrieve a single page of FleetInstance records from the API.
        Request is executed immediately

        :param unicode network_access_profile: The SID or unique name of the Network Access Profile of the Fleet
        :param str page_token: PageToken provided by the API
        :param int page_number: Page Number, this value is simply for client state
        :param int page_size: Number of records to return, defaults to 50

        :returns: Page of FleetInstance
        :rtype: twilio.rest.supersim.v1.fleet.FleetPage
        """
        data = values.of({
            'NetworkAccessProfile': network_access_profile,
            'PageToken': page_token,
            'Page': page_number,
            'PageSize': page_size,
        })

        response = self._version.page(method='GET', uri=self._uri, params=data, )

        return FleetPage(self._version, response, self._solution)

    def get_page(self, target_url):
        """
        Retrieve a specific page of FleetInstance records from the API.
        Request is executed immediately

        :param str target_url: API-generated URL for the requested results page

        :returns: Page of FleetInstance
        :rtype: twilio.rest.supersim.v1.fleet.FleetPage
        """
        response = self._version.domain.twilio.request(
            'GET',
            target_url,
        )

        return FleetPage(self._version, response, self._solution)

    def get(self, sid):
        """
        Constructs a FleetContext

        :param sid: The SID that identifies the resource to fetch

        :returns: twilio.rest.supersim.v1.fleet.FleetContext
        :rtype: twilio.rest.supersim.v1.fleet.FleetContext
        """
        return FleetContext(self._version, sid=sid, )

    def __call__(self, sid):
        """
        Constructs a FleetContext

        :param sid: The SID that identifies the resource to fetch

        :returns: twilio.rest.supersim.v1.fleet.FleetContext
        :rtype: twilio.rest.supersim.v1.fleet.FleetContext
        """
        return FleetContext(self._version, sid=sid, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Supersim.V1.FleetList>'


class FleetPage(Page):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, response, solution):
        """
        Initialize the FleetPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API

        :returns: twilio.rest.supersim.v1.fleet.FleetPage
        :rtype: twilio.rest.supersim.v1.fleet.FleetPage
        """
        super(FleetPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of FleetInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.supersim.v1.fleet.FleetInstance
        :rtype: twilio.rest.supersim.v1.fleet.FleetInstance
        """
        return FleetInstance(self._version, payload, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Supersim.V1.FleetPage>'


class FleetContext(InstanceContext):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, sid):
        """
        Initialize the FleetContext

        :param Version version: Version that contains the resource
        :param sid: The SID that identifies the resource to fetch

        :returns: twilio.rest.supersim.v1.fleet.FleetContext
        :rtype: twilio.rest.supersim.v1.fleet.FleetContext
        """
        super(FleetContext, self).__init__(version)

        # Path Solution
        self._solution = {'sid': sid, }
        self._uri = '/Fleets/{sid}'.format(**self._solution)

    def fetch(self):
        """
        Fetch the FleetInstance

        :returns: The fetched FleetInstance
        :rtype: twilio.rest.supersim.v1.fleet.FleetInstance
        """
        payload = self._version.fetch(method='GET', uri=self._uri, )

        return FleetInstance(self._version, payload, sid=self._solution['sid'], )

    def update(self, unique_name=values.unset, network_access_profile=values.unset):
        """
        Update the FleetInstance

        :param unicode unique_name: An application-defined string that uniquely identifies the resource
        :param unicode network_access_profile: The SID or unique name of the Network Access Profile of the Fleet

        :returns: The updated FleetInstance
        :rtype: twilio.rest.supersim.v1.fleet.FleetInstance
        """
        data = values.of({'UniqueName': unique_name, 'NetworkAccessProfile': network_access_profile, })

        payload = self._version.update(method='POST', uri=self._uri, data=data, )

        return FleetInstance(self._version, payload, sid=self._solution['sid'], )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Supersim.V1.FleetContext {}>'.format(context)


class FleetInstance(InstanceResource):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    class DataMetering(object):
        PAYG = "payg"

    def __init__(self, version, payload, sid=None):
        """
        Initialize the FleetInstance

        :returns: twilio.rest.supersim.v1.fleet.FleetInstance
        :rtype: twilio.rest.supersim.v1.fleet.FleetInstance
        """
        super(FleetInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'account_sid': payload.get('account_sid'),
            'sid': payload.get('sid'),
            'unique_name': payload.get('unique_name'),
            'date_created': deserialize.iso8601_datetime(payload.get('date_created')),
            'date_updated': deserialize.iso8601_datetime(payload.get('date_updated')),
            'url': payload.get('url'),
            'data_enabled': payload.get('data_enabled'),
            'data_limit': deserialize.integer(payload.get('data_limit')),
            'data_metering': payload.get('data_metering'),
            'commands_enabled': payload.get('commands_enabled'),
            'commands_url': payload.get('commands_url'),
            'commands_method': payload.get('commands_method'),
            'network_access_profile_sid': payload.get('network_access_profile_sid'),
        }

        # Context
        self._context = None
        self._solution = {'sid': sid or self._properties['sid'], }

    @property
    def _proxy(self):
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions.  All instance actions are proxied to the context

        :returns: FleetContext for this FleetInstance
        :rtype: twilio.rest.supersim.v1.fleet.FleetContext
        """
        if self._context is None:
            self._context = FleetContext(self._version, sid=self._solution['sid'], )
        return self._context

    @property
    def account_sid(self):
        """
        :returns: The SID of the Account that created the resource
        :rtype: unicode
        """
        return self._properties['account_sid']

    @property
    def sid(self):
        """
        :returns: The unique string that identifies the resource
        :rtype: unicode
        """
        return self._properties['sid']

    @property
    def unique_name(self):
        """
        :returns: An application-defined string that uniquely identifies the resource
        :rtype: unicode
        """
        return self._properties['unique_name']

    @property
    def date_created(self):
        """
        :returns: The ISO 8601 date and time in GMT when the resource was created
        :rtype: datetime
        """
        return self._properties['date_created']

    @property
    def date_updated(self):
        """
        :returns: The ISO 8601 date and time in GMT when the resource was last updated
        :rtype: datetime
        """
        return self._properties['date_updated']

    @property
    def url(self):
        """
        :returns: The absolute URL of the Fleet resource
        :rtype: unicode
        """
        return self._properties['url']

    @property
    def data_enabled(self):
        """
        :returns: Defines whether SIMs in the Fleet are capable of using data connectivity
        :rtype: bool
        """
        return self._properties['data_enabled']

    @property
    def data_limit(self):
        """
        :returns: The total data usage (download and upload combined) in Megabytes that each Sim resource assigned to the Fleet resource can consume
        :rtype: unicode
        """
        return self._properties['data_limit']

    @property
    def data_metering(self):
        """
        :returns: The model by which a SIM is metered and billed
        :rtype: FleetInstance.DataMetering
        """
        return self._properties['data_metering']

    @property
    def commands_enabled(self):
        """
        :returns: Defines whether SIMs in the Fleet are capable of sending and receiving machine-to-machine SMS via Commands
        :rtype: bool
        """
        return self._properties['commands_enabled']

    @property
    def commands_url(self):
        """
        :returns: The URL that will receive a webhook when a SIM in the Fleet originates a machine-to-machine SMS via Commands
        :rtype: unicode
        """
        return self._properties['commands_url']

    @property
    def commands_method(self):
        """
        :returns: A string representing the HTTP method to use when making a request to `commands_url`
        :rtype: unicode
        """
        return self._properties['commands_method']

    @property
    def network_access_profile_sid(self):
        """
        :returns: The SID of the Network Access Profile of the Fleet
        :rtype: unicode
        """
        return self._properties['network_access_profile_sid']

    def fetch(self):
        """
        Fetch the FleetInstance

        :returns: The fetched FleetInstance
        :rtype: twilio.rest.supersim.v1.fleet.FleetInstance
        """
        return self._proxy.fetch()

    def update(self, unique_name=values.unset, network_access_profile=values.unset):
        """
        Update the FleetInstance

        :param unicode unique_name: An application-defined string that uniquely identifies the resource
        :param unicode network_access_profile: The SID or unique name of the Network Access Profile of the Fleet

        :returns: The updated FleetInstance
        :rtype: twilio.rest.supersim.v1.fleet.FleetInstance
        """
        return self._proxy.update(unique_name=unique_name, network_access_profile=network_access_profile, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Supersim.V1.FleetInstance {}>'.format(context)
