/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.NoSuchElementException;
import org.apache.uima.UIMARuntimeException;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.impl.FSIntArrayIndex;
import org.apache.uima.cas.impl.FSIntIteratorImplBase;
import org.apache.uima.internal.util.IntComparator;
import org.apache.uima.internal.util.IntVector;

class IntIterator4sorted<T extends FeatureStructure>
extends FSIntIteratorImplBase<T> {
    private int itPos;
    private final IntComparator comp;
    private final IntVector indexIntVector;
    private final FSIntArrayIndex<T> fsIntArrayIndex;

    IntIterator4sorted(FSIntArrayIndex<T> index, int[] detectIllegalIndexUpdates) {
        super(index, detectIllegalIndexUpdates);
        this.indexIntVector = index.getVector();
        this.fsIntArrayIndex = index;
        this.itPos = 0;
        this.comp = null;
    }

    IntIterator4sorted(FSIntArrayIndex<T> index, int[] detectIllegalIndexUpdates, IntComparator comp) {
        super(index, detectIllegalIndexUpdates);
        this.fsIntArrayIndex = index;
        this.indexIntVector = index.getVector();
        this.comp = comp;
        this.itPos = 0;
    }

    @Override
    public boolean isValid() {
        return this.itPos >= 0 && this.itPos < this.indexIntVector.size();
    }

    @Override
    public void moveToFirst() {
        this.resetConcurrentModification();
        this.itPos = 0;
    }

    @Override
    public void moveToLast() {
        this.resetConcurrentModification();
        this.itPos = this.indexIntVector.size() - 1;
    }

    @Override
    public void moveToNext() {
        if (this.itPos < 0) {
            return;
        }
        this.checkConcurrentModification();
        ++this.itPos;
    }

    @Override
    public void moveToPrevious() {
        if (this.itPos >= this.indexIntVector.size()) {
            return;
        }
        this.checkConcurrentModification();
        --this.itPos;
    }

    @Override
    public int get() {
        if (!this.isValid()) {
            throw new NoSuchElementException();
        }
        this.checkConcurrentModification();
        return this.indexIntVector.get(this.itPos);
    }

    @Override
    public Object copy() {
        IntIterator4sorted<T> copy = new IntIterator4sorted<T>(this.fsIntArrayIndex, this.detectIllegalIndexUpdates, this.comp);
        copy.itPos = this.itPos;
        return copy;
    }

    @Override
    public int compareTo(FSIntIteratorImplBase<T> o) {
        return this.comp.compare(this.get(), ((IntIterator4sorted)o).get());
    }

    @Override
    public void moveTo(int i) {
        this.moveTo(i, false);
    }

    @Override
    void moveTo(int i, boolean isExact) {
        int pos;
        this.resetConcurrentModification();
        int n = pos = isExact ? this.fsIntArrayIndex.findEq(i) : this.fsIntArrayIndex.findLeftmost(i);
        if (pos >= 0) {
            this.itPos = pos;
        } else {
            if (isExact) {
                throw new UIMARuntimeException();
            }
            this.itPos = -(pos + 1);
        }
    }

    @Override
    public int ll_indexSize() {
        return this.indexIntVector.size();
    }
}

