/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.ooxml;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.poi.POIXMLDocument;
import org.apache.poi.POIXMLTextExtractor;
import org.apache.poi.extractor.ExtractorFactory;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageAccess;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationshipCollection;
import org.apache.poi.util.LocaleUtil;
import org.apache.poi.xslf.extractor.XSLFPowerPointExtractor;
import org.apache.poi.xslf.usermodel.XMLSlideShow;
import org.apache.poi.xslf.usermodel.XSLFRelation;
import org.apache.poi.xssf.extractor.XSSFBEventBasedExcelExtractor;
import org.apache.poi.xssf.extractor.XSSFEventBasedExcelExtractor;
import org.apache.poi.xwpf.extractor.XWPFWordExtractor;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFRelation;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.EmptyParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.microsoft.OfficeParserConfig;
import org.apache.tika.parser.microsoft.ooxml.AbstractOOXMLExtractor;
import org.apache.tika.parser.microsoft.ooxml.OOXMLParser;
import org.apache.tika.parser.microsoft.ooxml.POIXMLTextExtractorDecorator;
import org.apache.tika.parser.microsoft.ooxml.SXSLFPowerPointExtractorDecorator;
import org.apache.tika.parser.microsoft.ooxml.SXWPFWordExtractorDecorator;
import org.apache.tika.parser.microsoft.ooxml.XSLFPowerPointExtractorDecorator;
import org.apache.tika.parser.microsoft.ooxml.XSSFBExcelExtractorDecorator;
import org.apache.tika.parser.microsoft.ooxml.XSSFExcelExtractorDecorator;
import org.apache.tika.parser.microsoft.ooxml.XWPFWordExtractorDecorator;
import org.apache.tika.parser.microsoft.ooxml.xps.XPSExtractorDecorator;
import org.apache.tika.parser.microsoft.ooxml.xps.XPSTextExtractor;
import org.apache.tika.parser.microsoft.ooxml.xslf.XSLFEventBasedPowerPointExtractor;
import org.apache.tika.parser.microsoft.ooxml.xwpf.XWPFEventBasedWordExtractor;
import org.apache.tika.parser.pkg.ZipContainerDetector;
import org.apache.xmlbeans.XmlException;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class OOXMLExtractorFactory {
    public static void parse(InputStream stream, ContentHandler baseHandler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        Locale locale = context.get(Locale.class, LocaleUtil.getUserLocale());
        ExtractorFactory.setThreadPrefersEventExtractors(true);
        try {
            OPCPackage pkg;
            AbstractOOXMLExtractor extractor = null;
            TikaInputStream tis = TikaInputStream.cast(stream);
            if (tis != null && tis.getOpenContainer() instanceof OPCPackage) {
                pkg = (OPCPackage)tis.getOpenContainer();
            } else if (tis != null && tis.hasFile()) {
                pkg = OPCPackage.open(tis.getFile().getPath(), PackageAccess.READ);
                tis.setOpenContainer(pkg);
            } else {
                CloseShieldInputStream shield = new CloseShieldInputStream(stream);
                pkg = OPCPackage.open(shield);
            }
            MediaType type = ZipContainerDetector.detectOfficeOpenXML(pkg);
            if (type == null) {
                type = ZipContainerDetector.detectXPSOPC(pkg);
            }
            if (type == null || OOXMLParser.UNSUPPORTED_OOXML_TYPES.contains(type)) {
                EmptyParser.INSTANCE.parse(stream, baseHandler, metadata, context);
                return;
            }
            metadata.set("Content-Type", type.toString());
            POIXMLTextExtractor poiExtractor = null;
            OfficeParserConfig config = context.get(OfficeParserConfig.class);
            if (config.getUseSAXDocxExtractor()) {
                poiExtractor = OOXMLExtractorFactory.trySXWPF(pkg);
            }
            if (poiExtractor == null && config.getUseSAXPptxExtractor()) {
                poiExtractor = OOXMLExtractorFactory.trySXSLF(pkg);
            }
            if (type.equals(OOXMLParser.XPS)) {
                poiExtractor = new XPSTextExtractor(pkg);
            }
            if (poiExtractor == null) {
                poiExtractor = ExtractorFactory.createExtractor(pkg);
            }
            POIXMLDocument document = poiExtractor.getDocument();
            if (poiExtractor instanceof XSSFBEventBasedExcelExtractor) {
                extractor = new XSSFBExcelExtractorDecorator(context, poiExtractor, locale);
            } else if (poiExtractor instanceof XSSFEventBasedExcelExtractor) {
                extractor = new XSSFExcelExtractorDecorator(context, poiExtractor, locale);
            } else if (poiExtractor instanceof XWPFEventBasedWordExtractor) {
                extractor = new SXWPFWordExtractorDecorator(metadata, context, (XWPFEventBasedWordExtractor)poiExtractor);
                metadata.add("X-Parsed-By", XWPFEventBasedWordExtractor.class.getCanonicalName());
            } else if (poiExtractor instanceof XSLFEventBasedPowerPointExtractor) {
                extractor = new SXSLFPowerPointExtractorDecorator(metadata, context, (XSLFEventBasedPowerPointExtractor)poiExtractor);
                metadata.add("X-Parsed-By", XSLFEventBasedPowerPointExtractor.class.getCanonicalName());
            } else if (poiExtractor instanceof XPSTextExtractor) {
                extractor = new XPSExtractorDecorator(context, poiExtractor);
            } else {
                if (document == null) {
                    throw new TikaException("Expecting UserModel based POI OOXML extractor with a document, but none found. The extractor returned was a " + poiExtractor);
                }
                extractor = document instanceof XMLSlideShow ? new XSLFPowerPointExtractorDecorator(context, (XSLFPowerPointExtractor)poiExtractor) : (document instanceof XWPFDocument ? new XWPFWordExtractorDecorator(metadata, context, (XWPFWordExtractor)poiExtractor) : new POIXMLTextExtractorDecorator(context, poiExtractor));
            }
            extractor.getMetadataExtractor().extract(metadata);
            extractor.getXHTML(baseHandler, metadata, context);
        }
        catch (IllegalArgumentException e) {
            if (e.getMessage() != null && e.getMessage().startsWith("No supported documents found")) {
                throw new TikaException("TIKA-418: RuntimeException while getting content for thmx and xps file types", e);
            }
            throw new TikaException("Error creating OOXML extractor", e);
        }
        catch (InvalidFormatException e) {
            throw new TikaException("Error creating OOXML extractor", e);
        }
        catch (OpenXML4JException e) {
            throw new TikaException("Error creating OOXML extractor", e);
        }
        catch (XmlException e) {
            throw new TikaException("Error creating OOXML extractor", e);
        }
    }

    private static POIXMLTextExtractor trySXWPF(OPCPackage pkg) throws XmlException, OpenXML4JException, IOException {
        PackageRelationshipCollection packageRelationshipCollection = pkg.getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument");
        if (packageRelationshipCollection.size() == 0) {
            packageRelationshipCollection = pkg.getRelationshipsByType("http://purl.oclc.org/ooxml/officeDocument/relationships/officeDocument");
        }
        if (packageRelationshipCollection.size() == 0) {
            return null;
        }
        PackagePart corePart = pkg.getPart(packageRelationshipCollection.getRelationship(0));
        String targetContentType = corePart.getContentType();
        for (XWPFRelation relation : XWPFWordExtractor.SUPPORTED_TYPES) {
            if (!targetContentType.equals(relation.getContentType())) continue;
            return new XWPFEventBasedWordExtractor(pkg);
        }
        return null;
    }

    private static POIXMLTextExtractor trySXSLF(OPCPackage pkg) throws XmlException, OpenXML4JException, IOException {
        PackageRelationshipCollection packageRelationshipCollection = pkg.getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument");
        if (packageRelationshipCollection.size() == 0) {
            packageRelationshipCollection = pkg.getRelationshipsByType("http://purl.oclc.org/ooxml/officeDocument/relationships/officeDocument");
        }
        if (packageRelationshipCollection.size() == 0) {
            return null;
        }
        PackagePart corePart = pkg.getPart(packageRelationshipCollection.getRelationship(0));
        String targetContentType = corePart.getContentType();
        XSLFRelation[] xslfRelations = XSLFPowerPointExtractor.SUPPORTED_TYPES;
        for (int i = 0; i < xslfRelations.length; ++i) {
            XSLFRelation xslfRelation = xslfRelations[i];
            if (!xslfRelation.getContentType().equals(targetContentType)) continue;
            return new XSLFEventBasedPowerPointExtractor(pkg);
        }
        if (XSLFRelation.THEME_MANAGER.getContentType().equals(targetContentType)) {
            return new XSLFEventBasedPowerPointExtractor(pkg);
        }
        return null;
    }
}

