/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwmf.usermodel;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.poi.hwmf.draw.HwmfGraphics;
import org.apache.poi.hwmf.record.HwmfHeader;
import org.apache.poi.hwmf.record.HwmfPlaceableHeader;
import org.apache.poi.hwmf.record.HwmfRecord;
import org.apache.poi.hwmf.record.HwmfRecordType;
import org.apache.poi.hwmf.record.HwmfWindowing;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.LittleEndianInputStream;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;
import org.apache.poi.util.RecordFormatException;
import org.apache.poi.util.Units;

public class HwmfPicture {
    private static final POILogger logger = POILogFactory.getLogger(HwmfPicture.class);
    final List<HwmfRecord> records;
    final HwmfPlaceableHeader placeableHeader;
    final HwmfHeader header;

    public HwmfPicture(InputStream inputStream) throws IOException {
        block8: {
            long skipped;
            int remainingSize;
            this.records = new ArrayList<HwmfRecord>();
            BufferedInputStream bis = new BufferedInputStream(inputStream, 10000);
            LittleEndianInputStream leis = new LittleEndianInputStream(bis);
            this.placeableHeader = HwmfPlaceableHeader.readHeader(leis);
            this.header = new HwmfHeader(leis);
            do {
                HwmfRecord wr;
                if (leis.available() < 6) {
                    logger.log(7, "unexpected eof - wmf file was truncated");
                    break block8;
                }
                long recordSizeLong = leis.readUInt() * 2L;
                if (recordSizeLong > Integer.MAX_VALUE) {
                    throw new RecordFormatException("record size can't be > 2147483647");
                }
                if (recordSizeLong < 0L) {
                    throw new RecordFormatException("record size can't be < 0");
                }
                int recordSize = (int)recordSizeLong;
                short recordFunction = leis.readShort();
                int consumedSize = 6;
                HwmfRecordType wrt = HwmfRecordType.getById(recordFunction);
                if (wrt == null) {
                    throw new IOException("unexpected record type: " + recordFunction);
                }
                if (wrt == HwmfRecordType.eof) break block8;
                if (wrt.clazz == null) {
                    throw new IOException("unsupported record type: " + recordFunction);
                }
                try {
                    wr = wrt.clazz.newInstance();
                    this.records.add(wr);
                }
                catch (Exception e) {
                    throw (IOException)new IOException("can't create wmf record").initCause(e);
                }
                remainingSize = recordSize - (consumedSize += wr.init(leis, recordSize, recordFunction));
                if (remainingSize >= 0) continue;
                throw new RecordFormatException("read too many bytes. record size: " + recordSize + "; comsumed size: " + consumedSize);
            } while (remainingSize <= 0 || (skipped = IOUtils.skipFully(leis, remainingSize)) == (long)remainingSize);
            throw new RecordFormatException("Tried to skip " + remainingSize + " but skipped: " + skipped);
        }
    }

    public List<HwmfRecord> getRecords() {
        return Collections.unmodifiableList(this.records);
    }

    public void draw(Graphics2D ctx) {
        Dimension dim = this.getSize();
        int width = Units.pointsToPixel(dim.getWidth());
        int height = Units.pointsToPixel(dim.getHeight());
        Rectangle2D.Double bounds = new Rectangle2D.Double(0.0, 0.0, width, height);
        this.draw(ctx, bounds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(Graphics2D ctx, Rectangle2D graphicsBounds) {
        AffineTransform at = ctx.getTransform();
        try {
            Rectangle2D wmfBounds = this.getBounds();
            ctx.translate(graphicsBounds.getX(), graphicsBounds.getY());
            ctx.scale(graphicsBounds.getWidth() / wmfBounds.getWidth(), graphicsBounds.getHeight() / wmfBounds.getHeight());
            HwmfGraphics g = new HwmfGraphics(ctx, wmfBounds);
            for (HwmfRecord r : this.records) {
                r.draw(g);
            }
        }
        finally {
            ctx.setTransform(at);
        }
    }

    public Rectangle2D getBounds() {
        if (this.placeableHeader != null) {
            return this.placeableHeader.getBounds();
        }
        HwmfWindowing.WmfSetWindowOrg wOrg = null;
        HwmfWindowing.WmfSetWindowExt wExt = null;
        for (HwmfRecord r : this.getRecords()) {
            if (wOrg != null && wExt != null) break;
            if (r instanceof HwmfWindowing.WmfSetWindowOrg) {
                wOrg = (HwmfWindowing.WmfSetWindowOrg)r;
                continue;
            }
            if (!(r instanceof HwmfWindowing.WmfSetWindowExt)) continue;
            wExt = (HwmfWindowing.WmfSetWindowExt)r;
        }
        if (wOrg == null || wExt == null) {
            throw new RuntimeException("invalid wmf file - window records are incomplete.");
        }
        return new Rectangle2D.Double(wOrg.getX(), wOrg.getY(), wExt.getWidth(), wExt.getHeight());
    }

    public HwmfPlaceableHeader getPlaceableHeader() {
        return this.placeableHeader;
    }

    public HwmfHeader getHeader() {
        return this.header;
    }

    public Dimension getSize() {
        double inch = this.placeableHeader == null ? 1440.0 : (double)this.placeableHeader.getUnitsPerInch();
        Rectangle2D bounds = this.getBounds();
        double coeff = 72.0 / inch;
        return new Dimension((int)Math.round(bounds.getWidth() * coeff), (int)Math.round(bounds.getHeight() * coeff));
    }
}

