/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.instrument.classloading.glassfish;

import java.lang.instrument.ClassFileTransformer;
import org.springframework.instrument.classloading.LoadTimeWeaver;
import org.springframework.instrument.classloading.glassfish.GlassFishClassLoaderAdapter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class GlassFishLoadTimeWeaver
implements LoadTimeWeaver {
    private final GlassFishClassLoaderAdapter classLoader;

    public GlassFishLoadTimeWeaver() {
        this(ClassUtils.getDefaultClassLoader());
    }

    public GlassFishLoadTimeWeaver(ClassLoader classLoader) {
        Assert.notNull(classLoader, "ClassLoader must not be null");
        this.classLoader = new GlassFishClassLoaderAdapter(classLoader);
    }

    public void addTransformer(ClassFileTransformer transformer) {
        this.classLoader.addTransformer(transformer);
    }

    public ClassLoader getInstrumentableClassLoader() {
        return this.classLoader.getClassLoader();
    }

    public ClassLoader getThrowawayClassLoader() {
        return this.classLoader.getThrowawayClassLoader();
    }
}

