/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.StringUtil;
import org.apache.poi.util.SuppressForbidden;
import org.junit.Test;
import org.junit.internal.TextListener;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;
import org.junit.runner.notification.RunListener;

public final class OOXMLLite {
    private File _destDest;
    private File _testDir;
    private File _ooxmlJar;

    OOXMLLite(String dest, String test, String ooxmlJar) {
        this._destDest = new File(dest);
        this._testDir = new File(test);
        this._ooxmlJar = new File(ooxmlJar);
    }

    public static void main(String[] args) throws IOException, ClassNotFoundException {
        String dest = null;
        String test = null;
        String ooxml = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-dest")) {
                dest = args[++i];
                continue;
            }
            if (args[i].equals("-test")) {
                test = args[++i];
                continue;
            }
            if (!args[i].equals("-ooxml")) continue;
            ooxml = args[++i];
        }
        OOXMLLite builder = new OOXMLLite(dest, test, ooxml);
        builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void build() throws IOException, ClassNotFoundException {
        File destFile;
        ArrayList lst = new ArrayList();
        String exclude = StringUtil.join("|", "BaseTestXWorkbook", "BaseTestXSheet", "BaseTestXRow", "BaseTestXCell", "BaseTestXSSFPivotTable", "TestSXSSFWorkbook\\$\\d", "TestUnfixedBugs", "MemoryUsage", "TestDataProvider", "TestDataSamples", "All.+Tests", "ZipFileAssert", "AesZipFileZipEntrySource", "TempFileRecordingSXSSFWorkbookWithCustomZipEntrySource", "PkiTestUtils", "TestCellFormatPart\\$\\d", "TestSignatureInfo\\$\\d", "TestCertificateEncryption\\$CertData", "TestPOIXMLDocument\\$OPCParser", "TestPOIXMLDocument\\$TestFactory", "TestXSLFTextParagraph\\$DrawTextParagraphProxy", "TestXSSFExportToXML\\$\\d", "TestXSSFExportToXML\\$DummyEntityResolver", "TestFormulaEvaluatorOnXSSF\\$Result", "TestFormulaEvaluatorOnXSSF\\$SS", "TestMultiSheetFormulaEvaluatorOnXSSF\\$Result", "TestMultiSheetFormulaEvaluatorOnXSSF\\$SS", "TestXSSFBugs\\$\\d", "AddImageBench", "AddImageBench_jmhType_B\\d", "AddImageBench_benchCreatePicture_jmhTest", "TestEvilUnclosedBRFixingInputStream\\$EvilUnclosedBRFixingInputStream", "TempFileRecordingSXSSFWorkbookWithCustomZipEntrySource\\$TempFileRecordingSheetDataWriterWithDecorator", "TestXSSFBReader\\$1", "TestXSSFBReader\\$TestSheetHandler", "TestFormulaEvaluatorOnXSSF\\$1", "TestMultiSheetFormulaEvaluatorOnXSSF\\$1", "TestZipPackagePropertiesMarshaller\\$1", "SLCommonUtils", "TestPPTX2PNG\\$1");
        System.out.println("Collecting unit tests from " + this._testDir);
        OOXMLLite.collectTests(this._testDir, this._testDir, lst, ".+.class$", ".+(" + exclude + ").class");
        System.out.println("Found " + lst.size() + " classes");
        JUnitCore jUnitCore = new JUnitCore();
        jUnitCore.addListener((RunListener)new TextListener(System.out));
        Result result = jUnitCore.run(lst.toArray(new Class[lst.size()]));
        if (!result.wasSuccessful()) {
            throw new RuntimeException("Tests did not succeed, cannot build ooxml-lite jar");
        }
        System.out.println("Copying classes to " + this._destDest);
        Map<String, Class<?>> classes = OOXMLLite.getLoadedClasses(this._ooxmlJar.getName());
        for (Class<?> cls : classes.values()) {
            String className = cls.getName();
            String classRef = className.replace('.', '/') + ".class";
            destFile = new File(this._destDest, classRef);
            OOXMLLite.copyFile(cls.getResourceAsStream('/' + classRef), destFile);
            if (!cls.isInterface()) continue;
            for (Class<?> fc : cls.getDeclaredClasses()) {
                className = fc.getName();
                classRef = className.replace('.', '/') + ".class";
                destFile = new File(this._destDest, classRef);
                OOXMLLite.copyFile(fc.getResourceAsStream('/' + classRef), destFile);
            }
        }
        System.out.println("Copying .xsb resources");
        JarFile jar = new JarFile(this._ooxmlJar);
        Pattern p = Pattern.compile("schemaorg_apache_xmlbeans/(system|element)/.*\\.xsb");
        try {
            Enumeration<JarEntry> e = jar.entries();
            while (e.hasMoreElements()) {
                JarEntry je = e.nextElement();
                if (!p.matcher(je.getName()).matches()) continue;
                destFile = new File(this._destDest, je.getName());
                OOXMLLite.copyFile(jar.getInputStream(je), destFile);
            }
        }
        finally {
            jar.close();
        }
    }

    private static boolean checkForTestAnnotation(Class<?> testclass) {
        for (Method m : testclass.getDeclaredMethods()) {
            if (!m.isAnnotationPresent(Test.class)) continue;
            return true;
        }
        if (testclass.getSuperclass() != null) {
            for (Method m : testclass.getSuperclass().getDeclaredMethods()) {
                if (!m.isAnnotationPresent(Test.class)) continue;
                return true;
            }
        }
        System.out.println("Class " + testclass.getName() + " does not derive from TestCase and does not have a @Test annotation");
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void collectTests(File root, File arg, List<Class<?>> out, String ptrn, String exclude) throws ClassNotFoundException {
        if (arg.isDirectory()) {
            File[] files = arg.listFiles();
            if (files == null) return;
            for (File f : files) {
                OOXMLLite.collectTests(root, f, out, ptrn, exclude);
            }
            return;
        } else {
            String prefix;
            String path = arg.getAbsolutePath();
            String cls = path.substring((prefix = root.getAbsolutePath()).length() + 1).replace(File.separator, ".");
            if (!cls.matches(ptrn)) {
                return;
            }
            if (cls.matches(exclude)) {
                return;
            }
            if (cls.indexOf(36) != -1) {
                System.out.println("Inner class " + cls + " not included");
                return;
            }
            cls = cls.replace(".class", "");
            try {
                Class<?> testclass = Class.forName(cls);
                if (!TestCase.class.isAssignableFrom(testclass) && !OOXMLLite.checkForTestAnnotation(testclass)) return;
                out.add(testclass);
                return;
            }
            catch (Throwable e) {
                System.out.println("Class " + cls + " is not in classpath");
            }
        }
    }

    private static Map<String, Class<?>> getLoadedClasses(String ptrn) {
        Field _classes = AccessController.doPrivileged(new PrivilegedAction<Field>(){

            @Override
            @SuppressForbidden(value="TODO: Reflection works until Java 8 on Oracle/Sun JDKs, but breaks afterwards (different classloader types, access checks)")
            public Field run() {
                try {
                    Field fld = ClassLoader.class.getDeclaredField("classes");
                    fld.setAccessible(true);
                    return fld;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        ClassLoader appLoader = ClassLoader.getSystemClassLoader();
        try {
            Vector classes = (Vector)_classes.get(appLoader);
            HashMap map = new HashMap();
            for (Class cls : classes) {
                String jar;
                URL loc;
                CodeSource cs;
                ProtectionDomain pd = cls.getProtectionDomain();
                if (pd == null || (cs = pd.getCodeSource()) == null || (loc = cs.getLocation()) == null || !(jar = loc.toString()).contains(ptrn)) continue;
                map.put(cls.getName(), cls);
            }
            return map;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(InputStream srcStream, File destFile) throws IOException {
        File destDirectory = destFile.getParentFile();
        if (!destDirectory.exists() && !destDirectory.mkdirs()) {
            throw new RuntimeException("Can't create destination directory: " + destDirectory);
        }
        FileOutputStream destStream = new FileOutputStream(destFile);
        try {
            IOUtils.copy(srcStream, destStream);
        }
        finally {
            ((OutputStream)destStream).close();
        }
    }
}

