/**
 * pdfXtk-Extras - PDF Extraction Toolkit Extras
 * Copyright (c) by the authors/contributors.  All rights reserved.
 * This project includes code from PDFBox and TouchGraph.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the names pdfXtk or PDF Extraction Toolkit; nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * http://pdfxtk.sourceforge.net
 *
 */
package at.ac.tuwien.dbai.pdfwrap.comparators;

import java.util.Comparator;

import at.ac.tuwien.dbai.pdfwrap.table.CandidateColumn;

/**
 * @author Tamir Hassan, hassan@dbai.tuwien.ac.at
 * @version GraphWrap Beta 1
 */
public class ColumnComparator implements Comparator<CandidateColumn>
{
	public int compare(CandidateColumn obj1, CandidateColumn obj2)
	{
		// sorts in x order
		// changed 7.08.09
		// widthRaio = width/fontSize
//		double x1 = obj1.itemWidthRatio();
//		double x2 = obj2.itemWidthRatio();

		double x1 = obj1.getWidth()/obj1.getFontSize();
		double x2 = obj2.getWidth()/obj2.getFontSize();
		
		//System.err.println("int x1 - x2 equals: " + (int)(x1-x2));
		
		if (x1 > x2)
			return -1;
		else if (x1 == x2)
			return 0;
		else return 1;
		
		// return (int) (x1 - x2); //fractions less than 1 in magnitude mess this one up!
	}

	public boolean equals(Object obj)
	{
		return obj.equals(this);
	}
}