/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.fontbox.ttf.TTFDataStream;
import org.apache.fontbox.ttf.TrueTypeFont;

public class CMAPEncodingEntry {
    private int platformId;
    private int platformEncodingId;
    private long subTableOffset;
    private int[] glyphIdToCharacterCode;
    private Map<Integer, Integer> characterCodeToGlyphId = new HashMap<Integer, Integer>();

    public void initData(TrueTypeFont ttf, TTFDataStream data) throws IOException {
        this.platformId = data.readUnsignedShort();
        this.platformEncodingId = data.readUnsignedShort();
        this.subTableOffset = data.readUnsignedInt();
    }

    public void initSubtable(TrueTypeFont ttf, TTFDataStream data) throws IOException {
        int numGlyphs;
        data.seek(ttf.getCMAP().getOffset() + this.subTableOffset);
        int subtableFormat = data.readUnsignedShort();
        if (subtableFormat < 8) {
            long length = data.readUnsignedShort();
            long version = data.readUnsignedShort();
            numGlyphs = ttf.getMaximumProfile().getNumGlyphs();
        } else {
            data.readUnsignedShort();
            long length = data.readUnsignedInt();
            long version = data.readUnsignedInt();
            numGlyphs = ttf.getMaximumProfile().getNumGlyphs();
        }
        switch (subtableFormat) {
            case 0: {
                this.processSubtype0(ttf, data);
                break;
            }
            case 2: {
                this.processSubtype2(ttf, data, numGlyphs);
                break;
            }
            case 4: {
                this.processSubtype4(ttf, data, numGlyphs);
                break;
            }
            case 6: {
                this.processSubtype6(ttf, data, numGlyphs);
                break;
            }
            case 8: {
                this.processSubtype8(ttf, data, numGlyphs);
                break;
            }
            case 10: {
                this.processSubtype10(ttf, data, numGlyphs);
                break;
            }
            case 12: {
                this.processSubtype12(ttf, data, numGlyphs);
                break;
            }
            case 13: {
                this.processSubtype13(ttf, data, numGlyphs);
                break;
            }
            case 14: {
                this.processSubtype14(ttf, data, numGlyphs);
                break;
            }
            default: {
                throw new IOException("Unknown cmap format:" + subtableFormat);
            }
        }
    }

    protected void processSubtype8(TrueTypeFont ttf, TTFDataStream data, int numGlyphs) throws IOException {
        int[] is32 = data.readUnsignedByteArray(8192);
        long nbGroups = data.readUnsignedInt();
        if (nbGroups > 65536L) {
            throw new IOException("CMap ( Subtype8 ) is invalid");
        }
        this.glyphIdToCharacterCode = new int[numGlyphs];
        for (long i = 0L; i <= nbGroups; ++i) {
            long firstCode = data.readUnsignedInt();
            long endCode = data.readUnsignedInt();
            long startGlyph = data.readUnsignedInt();
            if (firstCode > endCode || 0L > firstCode) {
                throw new IOException("Range invalid");
            }
            for (long j = firstCode; j <= endCode; ++j) {
                int currentCharCode;
                if (j > Integer.MAX_VALUE) {
                    throw new IOException("[Sub Format 8] Invalid Character code");
                }
                if ((is32[(int)j / 8] & 1 << (int)j % 8) == 0) {
                    currentCharCode = (int)j;
                } else {
                    long LEAD_OFFSET = 55232L;
                    long lead = LEAD_OFFSET + (j >> 10);
                    long trail = 56320L + (j & 0x3FFL);
                    long SURROGATE_OFFSET = -56613888L;
                    long codepoint = (lead << 10) + trail + SURROGATE_OFFSET;
                    if (codepoint > Integer.MAX_VALUE) {
                        throw new IOException("[Sub Format 8] Invalid Character code");
                    }
                    currentCharCode = (int)codepoint;
                }
                long glyphIndex = startGlyph + (j - firstCode);
                if (glyphIndex > (long)numGlyphs || glyphIndex > Integer.MAX_VALUE) {
                    throw new IOException("CMap contains an invalid glyph index");
                }
                this.glyphIdToCharacterCode[(int)glyphIndex] = currentCharCode;
                this.characterCodeToGlyphId.put(currentCharCode, (int)glyphIndex);
            }
        }
    }

    protected void processSubtype10(TrueTypeFont ttf, TTFDataStream data, int numGlyphs) throws IOException {
        long startCode = data.readUnsignedInt();
        long numChars = data.readUnsignedInt();
        if (numChars > Integer.MAX_VALUE) {
            throw new IOException("Invalid number of Characters");
        }
        if (startCode < 0L || startCode > 0x10FFFFL || startCode + numChars > 0x10FFFFL || startCode + numChars >= 55296L && startCode + numChars <= 57343L) {
            throw new IOException("Invalid Characters codes");
        }
    }

    protected void processSubtype12(TrueTypeFont ttf, TTFDataStream data, int numGlyphs) throws IOException {
        long nbGroups = data.readUnsignedInt();
        this.glyphIdToCharacterCode = new int[numGlyphs];
        for (long i = 0L; i <= nbGroups; ++i) {
            long firstCode = data.readUnsignedInt();
            long endCode = data.readUnsignedInt();
            long startGlyph = data.readUnsignedInt();
            if (firstCode < 0L || firstCode > 0x10FFFFL || firstCode >= 55296L && firstCode <= 57343L) {
                throw new IOException("Invalid Characters codes");
            }
            if (endCode > 0L && (endCode < firstCode || endCode > 0x10FFFFL || endCode >= 55296L && endCode <= 57343L)) {
                throw new IOException("Invalid Characters codes");
            }
            for (long j = 0L; j <= endCode - firstCode; ++j) {
                if (firstCode + j > Integer.MAX_VALUE) {
                    throw new IOException("Character Code greater than Integer.MAX_VALUE");
                }
                long glyphIndex = startGlyph + j;
                if (glyphIndex > (long)numGlyphs || glyphIndex > Integer.MAX_VALUE) {
                    throw new IOException("CMap contains an invalid glyph index");
                }
                this.glyphIdToCharacterCode[(int)glyphIndex] = (int)(firstCode + j);
                this.characterCodeToGlyphId.put((int)(firstCode + j), (int)glyphIndex);
            }
        }
    }

    protected void processSubtype13(TrueTypeFont ttf, TTFDataStream data, int numGlyphs) throws IOException {
        long nbGroups = data.readUnsignedInt();
        for (long i = 0L; i <= nbGroups; ++i) {
            long firstCode = data.readUnsignedInt();
            long endCode = data.readUnsignedInt();
            long glyphId = data.readUnsignedInt();
            if (glyphId > (long)numGlyphs) {
                throw new IOException("CMap contains an invalid glyph index");
            }
            if (firstCode < 0L || firstCode > 0x10FFFFL || firstCode >= 55296L && firstCode <= 57343L) {
                throw new IOException("Invalid Characters codes");
            }
            if (endCode > 0L && (endCode < firstCode || endCode > 0x10FFFFL || endCode >= 55296L && endCode <= 57343L)) {
                throw new IOException("Invalid Characters codes");
            }
            for (long j = 0L; j <= endCode - firstCode; ++j) {
                if (firstCode + j > Integer.MAX_VALUE) {
                    throw new IOException("Character Code greater than Integer.MAX_VALUE");
                }
                this.glyphIdToCharacterCode[(int)glyphId] = (int)(firstCode + j);
                this.characterCodeToGlyphId.put((int)(firstCode + j), (int)glyphId);
            }
        }
    }

    protected void processSubtype14(TrueTypeFont ttf, TTFDataStream data, int numGlyphs) throws IOException {
        throw new IOException("CMap subtype 14 not yet implemented");
    }

    protected void processSubtype6(TrueTypeFont ttf, TTFDataStream data, int numGlyphs) throws IOException {
        int firstCode = data.readUnsignedShort();
        int entryCount = data.readUnsignedShort();
        this.glyphIdToCharacterCode = new int[numGlyphs];
        int[] glyphIdArray = data.readUnsignedShortArray(entryCount);
        for (int i = 0; i < entryCount; ++i) {
            this.glyphIdToCharacterCode[glyphIdArray[i]] = firstCode + i;
            this.characterCodeToGlyphId.put(firstCode + i, glyphIdArray[i]);
        }
    }

    protected void processSubtype4(TrueTypeFont ttf, TTFDataStream data, int numGlyphs) throws IOException {
        int segCountX2 = data.readUnsignedShort();
        int segCount = segCountX2 / 2;
        int searchRange = data.readUnsignedShort();
        int entrySelector = data.readUnsignedShort();
        int rangeShift = data.readUnsignedShort();
        int[] endCount = data.readUnsignedShortArray(segCount);
        int reservedPad = data.readUnsignedShort();
        int[] startCount = data.readUnsignedShortArray(segCount);
        int[] idDelta = data.readUnsignedShortArray(segCount);
        int[] idRangeOffset = data.readUnsignedShortArray(segCount);
        this.glyphIdToCharacterCode = new int[numGlyphs];
        long currentPosition = data.getCurrentPosition();
        for (int i = 0; i < segCount; ++i) {
            int start = startCount[i];
            int end = endCount[i];
            int delta = idDelta[i];
            int rangeOffset = idRangeOffset[i];
            if (start == 65535 || end == 65535) continue;
            for (int j = start; j <= end; ++j) {
                if (rangeOffset == 0) {
                    this.glyphIdToCharacterCode[(j + delta) % 65536] = j;
                    this.characterCodeToGlyphId.put(j, (j + delta) % 65536);
                    continue;
                }
                long glyphOffset = currentPosition + (long)((rangeOffset / 2 + (j - start) + (i - segCount)) * 2);
                data.seek(glyphOffset);
                int glyphIndex = data.readUnsignedShort();
                if (glyphIndex == 0) continue;
                glyphIndex += delta;
                if (this.glyphIdToCharacterCode[glyphIndex %= 65536] != 0) continue;
                this.glyphIdToCharacterCode[glyphIndex] = j;
                this.characterCodeToGlyphId.put(j, glyphIndex);
            }
        }
    }

    protected void processSubtype2(TrueTypeFont ttf, TTFDataStream data, int numGlyphs) throws IOException {
        int[] subHeaderKeys = new int[256];
        int maxSubHeaderIndex = 0;
        for (int i = 0; i < 256; ++i) {
            subHeaderKeys[i] = data.readUnsignedShort();
            maxSubHeaderIndex = Math.max(maxSubHeaderIndex, subHeaderKeys[i] / 8);
        }
        SubHeader[] subHeaders = new SubHeader[maxSubHeaderIndex + 1];
        for (int i = 0; i <= maxSubHeaderIndex; ++i) {
            int firstCode = data.readUnsignedShort();
            int entryCount = data.readUnsignedShort();
            short idDelta = data.readSignedShort();
            int idRangeOffset = data.readUnsignedShort();
            subHeaders[i] = new SubHeader(firstCode, entryCount, idDelta, idRangeOffset);
        }
        long startGlyphIndexOffset = data.getCurrentPosition();
        this.glyphIdToCharacterCode = new int[numGlyphs];
        for (int i = 0; i <= maxSubHeaderIndex; ++i) {
            SubHeader sh = subHeaders[i];
            int firstCode = sh.getFirstCode();
            for (int j = 0; j < sh.getEntryCount(); ++j) {
                int charCode = i * 8;
                charCode = (charCode << 8) + (firstCode + j);
                data.seek(startGlyphIndexOffset + (long)sh.getIdRangeOffset() + (long)(j * 2));
                int p = data.readUnsignedShort();
                this.glyphIdToCharacterCode[p += ((SubHeader)sh).getIdDelta() % 65536] = charCode;
                this.characterCodeToGlyphId.put(charCode, p);
            }
        }
    }

    protected void processSubtype0(TrueTypeFont ttf, TTFDataStream data) throws IOException {
        byte[] glyphMapping = data.read(256);
        this.glyphIdToCharacterCode = new int[256];
        for (int i = 0; i < glyphMapping.length; ++i) {
            int glyphIndex = (glyphMapping[i] + 256) % 256;
            this.glyphIdToCharacterCode[glyphIndex] = i;
            this.characterCodeToGlyphId.put(i, glyphIndex);
        }
    }

    public int[] getGlyphIdToCharacterCode() {
        return this.glyphIdToCharacterCode;
    }

    public void setGlyphIdToCharacterCode(int[] glyphIdToCharacterCodeValue) {
        this.glyphIdToCharacterCode = glyphIdToCharacterCodeValue;
    }

    public int getPlatformEncodingId() {
        return this.platformEncodingId;
    }

    public void setPlatformEncodingId(int platformEncodingIdValue) {
        this.platformEncodingId = platformEncodingIdValue;
    }

    public int getPlatformId() {
        return this.platformId;
    }

    public void setPlatformId(int platformIdValue) {
        this.platformId = platformIdValue;
    }

    public int getGlyphId(int characterCode) {
        if (this.characterCodeToGlyphId.containsKey(characterCode)) {
            return this.characterCodeToGlyphId.get(characterCode);
        }
        return 0;
    }

    private class SubHeader {
        private int firstCode;
        private int entryCount;
        private short idDelta;
        private int idRangeOffset;

        private SubHeader(int firstCode, int entryCount, short idDelta, int idRangeOffset) {
            this.firstCode = firstCode;
            this.entryCount = entryCount;
            this.idDelta = idDelta;
            this.idRangeOffset = idRangeOffset;
        }

        private int getFirstCode() {
            return this.firstCode;
        }

        private int getEntryCount() {
            return this.entryCount;
        }

        private short getIdDelta() {
            return this.idDelta;
        }

        private int getIdRangeOffset() {
            return this.idRangeOffset;
        }
    }
}

